/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.progressivebosses.base.Strings;
import insane96mcp.progressivebosses.setup.Config;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Health", description="Bonus Health and Bonus regeneration. The feature even fixes the Wither health bar not updating on spawn.")
public class HealthFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusPerDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maximumBonusRegenConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusRegenPerDifficultyConfig;
    public double bonusPerDifficulty = 30.0;
    public double maxBonusRegen = 2.0;
    public double bonusRegenPerDifficulty = 0.1;

    public HealthFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusPerDifficultyConfig = Config.builder.comment("Increase Wither's Health by this value per difficulty").defineInRange("Health Bonus per Difficulty", this.bonusPerDifficulty, 0.0, Double.MAX_VALUE);
        this.maximumBonusRegenConfig = Config.builder.comment("Maximum bonus regeneration per second given by \"Bonus Regeneration per Difficulty\". Set to 0 to disable bonus health regeneration. This doesn't affect the natural regeneration of the Wither (1 Health per Second).").defineInRange("Maximum Bonus Regeneration", this.maxBonusRegen, 0.0, Double.MAX_VALUE);
        this.bonusRegenPerDifficultyConfig = Config.builder.comment("How many half hearts will the Wither regen more per difficulty. This doesn't affect the natural regeneration of the Wither (1 Health per Second). (E.g. By default, with 6 Withers spawned, the Wither will heal 1.3 health per second).").defineInRange("Bonus Regeneration per Difficulty", this.bonusRegenPerDifficulty, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusPerDifficulty = (Double)this.bonusPerDifficultyConfig.get();
        this.maxBonusRegen = (Double)this.maximumBonusRegenConfig.get();
        this.bonusRegenPerDifficulty = (Double)this.bonusRegenPerDifficultyConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        boolean hasInvulTicks;
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.bonusPerDifficulty == 0.0) {
            return;
        }
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntity();
        if (wither.func_110148_a(Attributes.field_233818_a_).func_111127_a(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
            return;
        }
        CompoundNBT witherTags = wither.getPersistentData();
        double difficulty = witherTags.func_74760_g("progressivebosses:difficulty");
        MCUtils.applyModifier((LivingEntity)wither, (Attribute)Attributes.field_233818_a_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)(difficulty * this.bonusPerDifficulty), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        boolean bl = hasInvulTicks = wither.func_82212_n() > 0;
        if (hasInvulTicks) {
            wither.func_70606_j(Math.max(1.0f, wither.func_110138_aP() - 200.0f));
        }
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        if (this.bonusRegenPerDifficulty == 0.0 || this.maxBonusRegen == 0.0) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntity();
        this.fixInvulBossBar(wither);
        if (wither.func_82212_n() > 0) {
            return;
        }
        CompoundNBT tags = wither.getPersistentData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        if (wither.func_110143_aJ() <= 0.0f) {
            return;
        }
        float heal = (float)Math.min((double)difficulty * this.bonusRegenPerDifficulty, this.maxBonusRegen);
        wither.func_70691_i(heal /= 20.0f);
    }

    private void fixInvulBossBar(WitherEntity wither) {
        if (wither.func_82212_n() == 0) {
            return;
        }
        wither.field_184744_bE.func_186735_a(wither.func_110143_aJ() / wither.func_110138_aP());
    }
}

