/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.module.wither.ai.WitherChargeAttackGoal;
import insane96mcp.progressivebosses.module.wither.ai.WitherDoNothingGoal;
import insane96mcp.progressivebosses.module.wither.ai.WitherRangedAttackGoal;
import insane96mcp.progressivebosses.setup.Config;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Attack", description="Makes the Wither smarter (will no longer try to stand on the player's head ...), attack faster and hit harder")
public class AttackFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Boolean> applyToVanillaWitherConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maxChargeAttackChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> increasedDamageConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maxBarrageChancePerDiffConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> minBarrageDurationConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxBarrageDurationConfig;
    private final ForgeConfigSpec.ConfigValue<Double> skullVelocityMultiplierConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> attackIntervalConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> increaseAttackSpeedWhenNearConfig;
    public boolean applyToVanillaWither = true;
    public double maxChargeAttackChance = 0.06;
    public double increasedDamage = 0.04;
    public double maxBarrageChancePerDiff = 0.0035;
    public int minBarrageDuration = 20;
    public int maxBarrageDuration = 150;
    public double skullVelocityMultiplier = 2.75;
    public int attackInterval = 40;
    public boolean increaseAttackSpeedWhenNear = true;

    public AttackFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.applyToVanillaWitherConfig = Config.builder.comment("If the AI changes should be applied to the first wither spawned too.").define("Apply to Vanilla Wither", this.applyToVanillaWither);
        this.maxChargeAttackChanceConfig = Config.builder.comment("Max Chance every time the Wither takes damage to start a charge attack. The actual chance is inversely proportional to Wither's health (100% health = 0% chance, 50% health = 2.5% chance, ...).").defineInRange("Max Charge Attack Chance", this.maxChargeAttackChance, 0.0, 1.0);
        this.increasedDamageConfig = Config.builder.comment("Percentage bonus damage dealt by the Wither per difficulty.").defineInRange("Increased Damage", this.increasedDamage, 0.0, Double.MAX_VALUE);
        Config.builder.push("Barrage Attack");
        this.maxBarrageChancePerDiffConfig = Config.builder.comment("Chance (per difficulty) every time the Wither takes damage to start a barrage attack. The actual chance is inversely proportional to Wither's health and damage taken (more damage and less health = higher chance).").defineInRange("Max Barrage Attack Chance Per Difficulty", this.maxBarrageChancePerDiff, 0.0, 1.0);
        this.minBarrageDurationConfig = Config.builder.comment("Min time (in ticks) for the duration of the barrage attack. The actual duration is inversely proportional to Wither's health and damage taken (more damage and less health = higher chance)").defineInRange("Min Barrage Duration", this.minBarrageDuration, 0, Integer.MAX_VALUE);
        this.maxBarrageDurationConfig = Config.builder.comment("Max time (in ticks) for the duration of the barrage attack. The actual duration is inversely proportional to Wither's health (100% health = min duration, 0% health = max duration)").defineInRange("Max Barrage Duration", this.maxBarrageDuration, 0, Integer.MAX_VALUE);
        Config.builder.pop();
        Config.builder.comment("Wither Skull Changes").push("Skulls");
        this.skullVelocityMultiplierConfig = Config.builder.comment("Wither Skull Projectiles speed will be multiplied by this value.").defineInRange("Skull Velocity Multiplier", this.skullVelocityMultiplier, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
        Config.builder.comment("Attack Speed Changes").push("Attack Speed");
        this.attackIntervalConfig = Config.builder.comment("Every how many ticks (20 ticks = 1 seconds) the middle head will fire a projectile to the target.").defineInRange("Attack Interval", this.attackInterval, 0, Integer.MAX_VALUE);
        this.increaseAttackSpeedWhenNearConfig = Config.builder.comment("The middle head will attack faster (up to 40% of the attack speed) the nearer the target is to the Wither.").define("Increase Attack Speed when Near", this.increaseAttackSpeedWhenNear);
        Config.builder.pop();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.applyToVanillaWither = (Boolean)this.applyToVanillaWitherConfig.get();
        this.maxChargeAttackChance = (Double)this.maxChargeAttackChanceConfig.get();
        this.increasedDamage = (Double)this.increasedDamageConfig.get();
        this.maxBarrageChancePerDiff = (Double)this.maxBarrageChancePerDiffConfig.get();
        this.minBarrageDuration = (Integer)this.minBarrageDurationConfig.get();
        this.maxBarrageDuration = (Integer)this.maxBarrageDurationConfig.get();
        this.skullVelocityMultiplier = (Double)this.skullVelocityMultiplierConfig.get();
        this.attackInterval = (Integer)this.attackIntervalConfig.get();
        this.increaseAttackSpeedWhenNear = (Boolean)this.increaseAttackSpeedWhenNearConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        this.witherSkullSpeed(event.getEntity());
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntity();
        CompoundNBT compoundNBT = wither.getPersistentData();
        if (!(compoundNBT.func_74764_b("progressivebosses:difficulty") && compoundNBT.func_74760_g("progressivebosses:difficulty") != 0.0f || this.applyToVanillaWither)) {
            return;
        }
        this.setWitherAI(wither);
    }

    private void witherSkullSpeed(Entity entity) {
        if (!(entity instanceof WitherSkullEntity)) {
            return;
        }
        if (!this.isEnabled() || this.skullVelocityMultiplier == 0.0) {
            return;
        }
        WitherSkullEntity witherSkullEntity = (WitherSkullEntity)entity;
        if (Math.abs(witherSkullEntity.field_70232_b) > 10.0 || Math.abs(witherSkullEntity.field_70233_c) > 10.0 || Math.abs(witherSkullEntity.field_70230_d) > 10.0) {
            entity.func_174812_G();
            return;
        }
        witherSkullEntity.field_70232_b *= this.skullVelocityMultiplier;
        witherSkullEntity.field_70233_c *= this.skullVelocityMultiplier;
        witherSkullEntity.field_70230_d *= this.skullVelocityMultiplier;
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.maxChargeAttackChance == 0.0) {
            return;
        }
        if (!event.getEntity().func_70089_S()) {
            return;
        }
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntity();
        CompoundNBT witherTags = wither.getPersistentData();
        if (witherTags.func_74764_b("progressivebosses:charge_attack") && wither.field_70173_aa % 10 == 0) {
            float missingHealth = wither.func_110138_aP() - wither.func_110143_aJ();
            if (wither.func_110143_aJ() > 10.0f) {
                wither.func_70606_j(wither.func_110143_aJ() - 10.0f + missingHealth * 0.005f);
            }
        }
        if (!witherTags.func_74764_b("progressivebosses:charge_attack") && wither.field_70173_aa % 20 == 0) {
            this.doCharge(wither, (float)witherTags.func_74762_e("progressivebosses:unseen_player_ticks") / 20.0f);
        }
    }

    @SubscribeEvent
    public void onDamageDealt(LivingHurtEvent event) {
        WitherEntity wither;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.increasedDamage == 0.0) {
            return;
        }
        if (event.getSource().func_76364_f() instanceof WitherEntity) {
            wither = (WitherEntity)event.getSource().func_76364_f();
        } else if (event.getSource().func_76346_g() instanceof WitherEntity) {
            wither = (WitherEntity)event.getSource().func_76346_g();
        } else {
            return;
        }
        CompoundNBT compoundNBT = wither.getPersistentData();
        float difficulty = compoundNBT.func_74760_g("progressivebosses:difficulty");
        event.setAmount(event.getAmount() * (float)(1.0 + this.increasedDamage * (double)difficulty));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDamaged(LivingHurtEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!event.getEntity().func_70089_S()) {
            return;
        }
        if (!(event.getEntityLiving() instanceof WitherEntity)) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntityLiving();
        this.doBarrage(wither, event.getAmount());
        this.doCharge(wither, event.getAmount());
    }

    private void doBarrage(WitherEntity wither, float damageTaken) {
        if (this.maxBarrageChancePerDiff == 0.0) {
            return;
        }
        CompoundNBT witherTags = wither.getPersistentData();
        float difficulty = witherTags.func_74760_g("progressivebosses:difficulty");
        double missingHealthPerc = 1.0 - (double)(wither.func_110143_aJ() / wither.func_110138_aP());
        double chance = this.maxBarrageChancePerDiff * (double)difficulty * missingHealthPerc;
        chance *= (double)(damageTaken / 10.0f);
        double r = wither.func_70681_au().nextDouble();
        if (r < chance) {
            int duration = (int)((double)(this.maxBarrageDuration - this.minBarrageDuration) * missingHealthPerc + (double)this.minBarrageDuration);
            witherTags.func_74768_a("progressivebosses:barrage_attack", duration);
        }
    }

    private void doCharge(WitherEntity wither, float damageTaken) {
        if (this.maxChargeAttackChance == 0.0) {
            return;
        }
        CompoundNBT witherTags = wither.getPersistentData();
        double missingHealthPerc = 1.0 - (double)(wither.func_110143_aJ() / wither.func_110138_aP());
        double chance = this.maxChargeAttackChance * missingHealthPerc;
        chance *= (double)(damageTaken / 10.0f);
        double r = wither.func_70681_au().nextDouble();
        if (r < chance) {
            wither.func_82215_s(90);
            witherTags.func_74757_a("progressivebosses:charge_attack", true);
        }
    }

    public void setWitherAI(WitherEntity wither) {
        ArrayList<Goal> toRemove = new ArrayList<Goal>();
        wither.field_70714_bg.field_220892_d.forEach(goal -> {
            if (goal.func_220772_j() instanceof RangedAttackGoal) {
                toRemove.add(goal.func_220772_j());
            }
            if (goal.func_220772_j() instanceof WitherEntity.DoNothingGoal) {
                toRemove.add(goal.func_220772_j());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)wither.field_70714_bg).func_85156_a(arg_0));
        wither.field_70714_bg.func_75776_a(0, (Goal)new WitherDoNothingGoal(wither));
        wither.field_70714_bg.func_75776_a(2, (Goal)new WitherRangedAttackGoal(wither, this.attackInterval, 24.0f, this.increaseAttackSpeedWhenNear));
        wither.field_70714_bg.func_75776_a(2, (Goal)new WitherChargeAttackGoal(wither));
        wither.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)wither, PlayerEntity.class, 0, false, false, null));
    }

    public static class Consts {
        public static final int CHARGE_ATTACK_TICK_START = 90;
        public static final int CHARGE_ATTACK_TICK_CHARGE = 30;
    }
}

