/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.progressivebosses.base.Strings;
import insane96mcp.progressivebosses.module.elderguardian.ai.ElderMinionNearestAttackableTargetGoal;
import insane96mcp.progressivebosses.module.elderguardian.feature.BaseFeature;
import insane96mcp.progressivebosses.setup.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Minions", description="Elder Guardians will spawn Elder Minions.")
public class MinionFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> baseCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> cooldownReductionPerMissingGuardianConfig;
    public int baseCooldown = 200;
    public int cooldownReductionPerMissingGuardian = 60;

    public MinionFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.baseCooldownConfig = Config.builder.comment("Elder Guardians will spawn Elder Minions every this tick value (20 ticks = 1 sec).").defineInRange("Base Cooldown", this.baseCooldown, 0, Integer.MAX_VALUE);
        this.cooldownReductionPerMissingGuardianConfig = Config.builder.comment("The base cooldown is reduced by this value for each missing Elder Guardian.").defineInRange("Cooldown Reduction per Missing Elder", this.cooldownReductionPerMissingGuardian, 0, Integer.MAX_VALUE);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.baseCooldown = (Integer)this.baseCooldownConfig.get();
        this.cooldownReductionPerMissingGuardian = (Integer)this.cooldownReductionPerMissingGuardianConfig.get();
    }

    @SubscribeEvent
    public void onElderGuardianSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ElderGuardianEntity)) {
            return;
        }
        ElderGuardianEntity elderGuardian = (ElderGuardianEntity)event.getEntity();
        CompoundNBT witherTags = elderGuardian.getPersistentData();
        witherTags.func_74768_a("progressivebosses:elder_minion_cooldown", this.baseCooldown);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ElderGuardianEntity)) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        ElderGuardianEntity elderGuardian = (ElderGuardianEntity)event.getEntity();
        CompoundNBT elderGuardianTags = elderGuardian.getPersistentData();
        if (elderGuardian.func_110143_aJ() <= 0.0f) {
            return;
        }
        int cooldown = elderGuardianTags.func_74762_e("progressivebosses:elder_minion_cooldown");
        if (cooldown > 0) {
            elderGuardianTags.func_74768_a("progressivebosses:elder_minion_cooldown", cooldown - 1);
            return;
        }
        elderGuardianTags.func_74768_a("progressivebosses:elder_minion_cooldown", this.baseCooldown - this.cooldownReductionPerMissingGuardian * BaseFeature.getDeadElderGuardians(elderGuardian));
        int radius = 24;
        BlockPos pos1 = elderGuardian.func_233580_cy_().func_177982_a(-radius, -radius, -radius);
        BlockPos pos2 = elderGuardian.func_233580_cy_().func_177982_a(radius, radius, radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2);
        List players = world.func_225317_b(ServerPlayerEntity.class, bb);
        if (players.isEmpty()) {
            return;
        }
        List minionsInAABB = world.func_225316_b(GuardianEntity.class, elderGuardian.func_174813_aQ().func_186662_g(12.0), entity -> entity.getPersistentData().func_74764_b("progressivebosses:elder_minion"));
        int minionsCountInAABB = minionsInAABB.size();
        if (minionsCountInAABB >= 5) {
            return;
        }
        this.summonMinion(world, new Vector3d(elderGuardian.func_226277_ct_(), elderGuardian.func_226278_cu_(), elderGuardian.func_226281_cx_()));
    }

    public GuardianEntity summonMinion(World world, Vector3d pos) {
        GuardianEntity elderMinion = new GuardianEntity(EntityType.field_200761_A, world);
        CompoundNBT minionTags = elderMinion.getPersistentData();
        minionTags.func_74757_a("mobspropertiesrandomness:processed", true);
        minionTags.func_74757_a("progressivebosses:elder_minion", true);
        elderMinion.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        elderMinion.func_200203_b((ITextComponent)new TranslationTextComponent("progressivebosses:elder_minion"));
        elderMinion.field_184659_bA = LootTables.field_186419_a;
        MCUtils.applyModifier((LivingEntity)elderMinion, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)Strings.AttributeModifiers.SWIM_SPEED_BONUS_UUID, (String)"progressivebosses:swim_speed_bonus", (double)2.0, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        for (PrioritizedGoal prioritizedGoal : elderMinion.field_70715_bh.field_220892_d) {
            if (!(prioritizedGoal.func_220772_j() instanceof NearestAttackableTargetGoal)) continue;
            goalsToRemove.add(prioritizedGoal.func_220772_j());
        }
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)elderMinion.field_70714_bg).func_85156_a(arg_0));
        elderMinion.field_70715_bh.func_75776_a(1, new ElderMinionNearestAttackableTargetGoal<PlayerEntity>((MobEntity)elderMinion, PlayerEntity.class, true));
        world.func_217376_c((Entity)elderMinion);
        return elderMinion;
    }
}

