/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.phase;

import insane96mcp.progressivebosses.module.Modules;
import insane96mcp.progressivebosses.module.dragon.feature.CrystalFeature;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.Phase;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.gen.feature.EndSpikeFeature;

public class CrystalRespawnPhase
extends Phase {
    private static PhaseType<CrystalRespawnPhase> CRYSTAL_RESPAWN;
    public Vector3d targetLocation;
    private int tick = 0;
    private boolean respawning = false;
    private final ArrayList<EndSpikeFeature.EndSpike> spikesToRespawn = new ArrayList();

    public CrystalRespawnPhase(EnderDragonEntity dragonIn) {
        super(dragonIn);
    }

    public void func_188659_c() {
        CompoundNBT dragonTags = this.field_188661_a.getPersistentData();
        float difficulty = dragonTags.func_74760_g("progressivebosses:difficulty");
        if (this.targetLocation == null) {
            if (this.spikesToRespawn.isEmpty()) {
                this.field_188661_a.func_184670_cT().func_188758_a(PhaseType.field_188745_e);
                return;
            }
            this.targetLocation = new Vector3d((double)this.spikesToRespawn.get(0).func_186151_a() + 0.5, (double)this.spikesToRespawn.get(0).func_186149_d() + 5.5, (double)this.spikesToRespawn.get(0).func_186152_b() + 0.5);
        }
        int tickSpawnCystal = (int)(50.0f - difficulty / 4.0f);
        if (!this.respawning) {
            double d0 = this.targetLocation.func_186679_c(this.field_188661_a.func_226277_ct_(), this.field_188661_a.func_226278_cu_(), this.field_188661_a.func_226281_cx_());
            if (d0 < 16.0) {
                this.field_188661_a.func_213317_d(Vector3d.field_186680_a);
                this.respawning = true;
            }
        } else {
            ++this.tick;
            this.field_188661_a.func_213317_d(Vector3d.field_186680_a);
            if (this.tick <= 25) {
                this.field_188661_a.func_184185_a(SoundEvents.field_187525_aO, 4.0f, 1.0f);
            }
            if (this.tick >= tickSpawnCystal) {
                if (this.field_188661_a.func_110143_aJ() < 10.0f) {
                    this.field_188661_a.func_184670_cT().func_188758_a(PhaseType.field_188745_e);
                    return;
                }
                double x = this.spikesToRespawn.get(0).func_186151_a();
                double y = this.spikesToRespawn.get(0).func_186149_d();
                double z = this.spikesToRespawn.get(0).func_186152_b();
                if (this.field_188661_a.func_70681_au().nextDouble() < Modules.dragon.crystal.crystalRespawnInsideTowerChance * (double)difficulty) {
                    CrystalFeature.generateCrystalInTower(this.field_188661_a.field_70170_p, x + 0.5, y + 1.0, z + 0.5);
                } else {
                    EnderCrystalEntity crystal = new EnderCrystalEntity(this.field_188661_a.field_70170_p, x + 0.5, y + 1.0, z + 0.5);
                    crystal.func_184517_a(true);
                    crystal.field_70170_p.func_217385_a((Entity)this.field_188661_a, x + 0.5, y + 1.5, z + 0.5, 5.0f, Explosion.Mode.NONE);
                    this.field_188661_a.field_70170_p.func_217376_c((Entity)crystal);
                    CrystalFeature.generateCage(crystal.field_70170_p, crystal.func_233580_cy_());
                }
                this.field_188661_a.func_213403_a(this.field_188661_a.field_70986_h, DamageSource.func_188405_b((LivingEntity)this.field_188661_a), 10.0f);
                this.spikesToRespawn.remove(0);
                this.tick = 0;
                this.respawning = false;
                this.targetLocation = null;
            }
        }
    }

    public boolean func_188654_a() {
        return this.respawning;
    }

    public void func_188660_d() {
        this.targetLocation = null;
        this.spikesToRespawn.clear();
    }

    public float func_188651_f() {
        return 24.0f;
    }

    @Nullable
    public Vector3d func_188650_g() {
        return this.targetLocation;
    }

    public void addCrystalRespawn(EndSpikeFeature.EndSpike spike) {
        if (!this.spikesToRespawn.contains(spike)) {
            this.spikesToRespawn.add(spike);
        }
    }

    public PhaseType<CrystalRespawnPhase> func_188652_i() {
        return CRYSTAL_RESPAWN;
    }

    public static PhaseType<CrystalRespawnPhase> getPhaseType() {
        return CRYSTAL_RESPAWN;
    }

    public static void init() {
        CRYSTAL_RESPAWN = PhaseType.func_188735_a(CrystalRespawnPhase.class, (String)"CrystalRespawn");
    }
}

