/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.classutils.Drop;
import insane96mcp.progressivebosses.setup.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Rewards", description="Bonus Experience and Dragon Egg per player")
public class RewardFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusExperienceConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> dragonEggPerPlayerConfig;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> dropsListConfig;
    public double bonusExperience = 1.0;
    public boolean dragonEggPerPlayer = true;
    public ArrayList<Drop> dropsList;

    public RewardFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusExperienceConfig = Config.builder.comment("How much more experience (percentage) will Dragon drop per Difficulty. The percentage is additive (e.g. with this set to 100%, 7 dragons killed = 700% more experience)").defineInRange("Bonus Experience per Difficulty", this.bonusExperience, 0.0, Double.MAX_VALUE);
        this.dragonEggPerPlayerConfig = Config.builder.comment("If true whenever a player, that has never killed the dragon, kills the dragon a Dragon Egg \u00c3\u00ac\u00c3\u00ac will drop. E.g. If 2 players kill the Dragon for the first time, she will drop 2 Dragon Eggs").define("Dragon Egg per Player", this.dragonEggPerPlayer);
        this.dropsListConfig = Config.builder.comment("A list of drops for the Dragons. Entry format: item,amount,difficulty_required,chance,difficulty_mode,chance_mode\nitem: item id\namount: amount\ndifficulty_required: the amount of difficulty required for the item to drop, works differently based on mode\nchance: chance for the drop to happen, between 0 and 1\ndifficulty_mode:\n* MINIMUM: will try to drop the item when the difficulty matches or is higher\n* PER_DIFFICULTY: will try to drop the item once per difficulty (e.g. at difficulty 10, difficulty required 3, there is the chance to drop the item, trying 7 times)\nchance_mode:\n* FLAT: chance is the percentage chance for the item to drop if the difficulty criteria matches\n* SCALING: each point of difficulty >= 'difficulty to drop the item' will be multiplied by the chance (e.g. chance 2% and difficulty 10, difficulty required 5, chance to drop the item will be chance * (difficulty - difficulty_required + 1) = 2% * (10 - 5 + 1) = 12%)\nBy default Withers have 2% chance per difficulty >= 2 to drop 1 shard + 4% chance per difficulty >= 4 to drop 2 shards + 8% chance per difficulty >= 8 to drop 4 shards.").defineList("Drops", ArrayList::new, o -> o instanceof String);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusExperience = (Double)this.bonusExperienceConfig.get();
        this.dragonEggPerPlayer = (Boolean)this.dragonEggPerPlayerConfig.get();
        this.dropsList = Drop.parseDropsList((List)this.dropsListConfig.get());
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        this.dropExperience(dragon);
        this.dropEgg(dragon);
    }

    private void dropExperience(EnderDragonEntity dragon) {
        if (this.bonusExperience == 0.0) {
            return;
        }
        if (dragon.field_70995_bG <= 150 || dragon.field_70995_bG % 5 != 0) {
            return;
        }
        if (dragon.func_184664_cU() == null) {
            return;
        }
        CompoundNBT dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.func_74760_g("progressivebosses:difficulty");
        if ((double)difficulty == 0.0) {
            return;
        }
        int bonusXP = (int)(500.0 * this.bonusExperience * (double)difficulty * 0.08);
        if (dragon.field_70995_bG == 200) {
            bonusXP += (int)(500.0 * this.bonusExperience * (double)difficulty * 0.2);
        }
        while (bonusXP > 0) {
            int i = ExperienceOrbEntity.func_70527_a((int)bonusXP);
            bonusXP -= i;
            dragon.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(dragon.field_70170_p, dragon.func_213303_ch().func_82615_a(), dragon.func_213303_ch().func_82617_b(), dragon.func_213303_ch().func_82616_c(), i));
        }
    }

    private void dropEgg(EnderDragonEntity dragon) {
        if (!this.dragonEggPerPlayer) {
            return;
        }
        if (dragon.field_70995_bG != 100) {
            return;
        }
        CompoundNBT tags = dragon.getPersistentData();
        int eggsToDrop = tags.func_74762_e("progressivebosses:eggs_to_drop");
        if (dragon.func_184664_cU() != null && !dragon.func_184664_cU().func_186102_d()) {
            --eggsToDrop;
        }
        for (int i = 0; i < eggsToDrop; ++i) {
            dragon.field_70170_p.func_175656_a(new BlockPos(0, 255 - i, 0), Blocks.field_150380_bt.func_176223_P());
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.dropsList.isEmpty()) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntityLiving();
        CompoundNBT tags = dragon.getPersistentData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        for (Drop drop : this.dropsList) {
            drop.drop(dragon.field_70170_p, dragon.func_213303_ch(), difficulty);
        }
    }
}

