/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.setup.Config;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Resistances & Vulnerabilities", description="Handles the Damage Resistances and Vulnerabilities")
public class ResistancesFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusCurHealthDirectDamageConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusCurHealthIndirectDamageConfig;
    private final ForgeConfigSpec.ConfigValue<Double> damageRedutionWhenSittingConfig;
    private final ForgeConfigSpec.ConfigValue<Double> explosionDamageReductionConfig;
    public double bonusCurHealthDirectDamage = 0.02;
    public double bonusCurHealthIndirectDamage = 0.008;
    public double damageRedutionWhenSitting = 0.0125;
    public double explosionDamageReduction = 0.5;
    private static final List<PhaseType<? extends IPhase>> sittingPhases = Arrays.asList(PhaseType.field_188747_g, PhaseType.field_188748_h, PhaseType.field_188746_f, PhaseType.field_188745_e);

    public ResistancesFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusCurHealthDirectDamageConfig = Config.builder.comment("Percentage of Dragon's current health dealth as Bonus damage when attacked directly (melee) and she's not at the center.").defineInRange("Bonus Current Health Direct Damage", this.bonusCurHealthDirectDamage, 0.0, Double.MAX_VALUE);
        this.bonusCurHealthIndirectDamageConfig = Config.builder.comment("Percentage of Dragon's current health dealth as Bonus damage when attacked indirectly (e.g. arrows) and she's not at the center.").defineInRange("Bonus Current Health Indirect Damage", this.bonusCurHealthIndirectDamage, 0.0, Double.MAX_VALUE);
        this.damageRedutionWhenSittingConfig = Config.builder.comment("Melee Damage reduction per difficulty while the Ender Dragon is at the center.").defineInRange("Melee Damage reduction while at the center", this.damageRedutionWhenSitting, 0.0, Double.MAX_VALUE);
        this.explosionDamageReductionConfig = Config.builder.comment("Damage reduction when hit by explosions.").defineInRange("Explosion Damage reduction", this.explosionDamageReduction, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusCurHealthDirectDamage = (Double)this.bonusCurHealthDirectDamageConfig.get();
        this.bonusCurHealthIndirectDamage = (Double)this.bonusCurHealthIndirectDamageConfig.get();
        this.damageRedutionWhenSitting = (Double)this.damageRedutionWhenSittingConfig.get();
        this.explosionDamageReduction = (Double)this.explosionDamageReductionConfig.get();
    }

    @SubscribeEvent
    public void onDragonDamage(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        this.bonusDamageNotInCenter(event, dragon);
        this.meleeDamageReduction(event, dragon);
        this.explosionDamageReduction(event, dragon);
    }

    private void bonusDamageNotInCenter(LivingDamageEvent event, EnderDragonEntity dragon) {
        if (this.bonusCurHealthDirectDamage == 0.0 && this.bonusCurHealthIndirectDamage == 0.0) {
            return;
        }
        if (event.getSource().func_94541_c() && !event.getSource().func_76355_l().equals("fireworks")) {
            return;
        }
        if (sittingPhases.contains(dragon.func_184670_cT().func_188756_a().func_188652_i())) {
            return;
        }
        float curHealth = dragon.func_110143_aJ();
        if (event.getSource().func_76364_f() instanceof PlayerEntity) {
            event.setAmount(event.getAmount() + (float)((double)curHealth * this.bonusCurHealthDirectDamage));
        } else if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            event.setAmount(event.getAmount() + (float)((double)curHealth * this.bonusCurHealthIndirectDamage));
        }
    }

    private void meleeDamageReduction(LivingDamageEvent event, EnderDragonEntity dragon) {
        if (this.damageRedutionWhenSitting == 0.0) {
            return;
        }
        CompoundNBT compoundNBT = dragon.getPersistentData();
        float difficulty = compoundNBT.func_74760_g("progressivebosses:difficulty");
        if (sittingPhases.contains(dragon.func_184670_cT().func_188756_a().func_188652_i()) && event.getSource().func_76364_f() instanceof PlayerEntity) {
            event.setAmount(event.getAmount() - (float)((double)event.getAmount() * (this.damageRedutionWhenSitting * (double)difficulty)));
        }
    }

    private void explosionDamageReduction(LivingDamageEvent event, EnderDragonEntity dragon) {
        if (this.explosionDamageReduction == 0.0) {
            return;
        }
        if (event.getSource().func_94541_c() && !event.getSource().func_76355_l().equals("fireworks")) {
            event.setAmount(event.getAmount() - (float)((double)event.getAmount() * this.explosionDamageReduction));
        }
    }
}

