/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.insanelib.utils.RandomHelper;
import insane96mcp.progressivebosses.base.Strings;
import insane96mcp.progressivebosses.module.dragon.ai.PBNearestAttackableTargetGoal;
import insane96mcp.progressivebosses.setup.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Larva", description="Mini things that are just annoying.")
public class LarvaFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> larvaAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> bonusLarvaEveryDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxSpawnedConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> minCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> dragonImmuneConfig;
    public int larvaAtDifficulty = 1;
    public int bonusLarvaEveryDifficulty = 2;
    public int maxSpawned = 7;
    public int minCooldown = 800;
    public int maxCooldown = 1400;
    public boolean dragonImmune = true;

    public LarvaFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.larvaAtDifficultyConfig = Config.builder.comment("At which difficulty the Ender Dragon starts spawning Larvae").defineInRange("Larva at Difficulty", this.larvaAtDifficulty, 0, Integer.MAX_VALUE);
        this.bonusLarvaEveryDifficultyConfig = Config.builder.comment("As the Wither starts spawning Minions, every how much difficulty the Wither will spawn one more Minion").defineInRange("Bonus Larva Every Difficulty", this.bonusLarvaEveryDifficulty, 0, Integer.MAX_VALUE);
        this.maxSpawnedConfig = Config.builder.comment("Maximum Larva spawned by the Ender Dragon").defineInRange("Max Larvae Spawned", this.maxSpawned, 0, Integer.MAX_VALUE);
        this.minCooldownConfig = Config.builder.comment("Minimum ticks (20 ticks = 1 seconds) after Minions can spwan.").defineInRange("Minimum Cooldown", this.minCooldown, 0, Integer.MAX_VALUE);
        this.maxCooldownConfig = Config.builder.comment("Maximum ticks (20 ticks = 1 seconds) after Minions can spwan.").defineInRange("Maximum Cooldown", this.maxCooldown, 0, Integer.MAX_VALUE);
        this.dragonImmuneConfig = Config.builder.comment("Dragon Minions are immune to any damage from the Ender Dragon, either direct or Acid.").define("Dragon Immune", this.dragonImmune);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.larvaAtDifficulty = (Integer)this.larvaAtDifficultyConfig.get();
        this.bonusLarvaEveryDifficulty = (Integer)this.bonusLarvaEveryDifficultyConfig.get();
        this.maxSpawned = (Integer)this.maxSpawnedConfig.get();
        this.minCooldown = (Integer)this.minCooldownConfig.get();
        this.maxCooldown = (Integer)this.maxCooldownConfig.get();
        if (this.minCooldown > this.maxCooldown) {
            this.minCooldown = this.maxCooldown;
        }
        this.dragonImmune = (Boolean)this.dragonImmuneConfig.get();
    }

    @SubscribeEvent
    public void onDragonSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        CompoundNBT dragonTags = dragon.getPersistentData();
        int cooldown = (int)((double)RandomHelper.getInt((Random)dragon.func_70681_au(), (int)this.minCooldown, (int)this.maxCooldown) * 0.5);
        dragonTags.func_74768_a("progressivebosses:dragon_larva_cooldown", cooldown);
    }

    @SubscribeEvent
    public void onLarvaSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EndermiteEntity)) {
            return;
        }
        EndermiteEntity endermite = (EndermiteEntity)event.getEntity();
        CompoundNBT tags = endermite.getPersistentData();
        if (!tags.func_74764_b("progressivebosses:dragon_larva")) {
            return;
        }
        LarvaFeature.setLarvaAI(endermite);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        CompoundNBT dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.func_74760_g("progressivebosses:difficulty");
        if (difficulty < (float)this.larvaAtDifficulty) {
            return;
        }
        if (dragon.func_110143_aJ() <= 0.0f) {
            return;
        }
        int cooldown = dragonTags.func_74762_e("progressivebosses:dragon_larva_cooldown");
        if (cooldown > 0) {
            dragonTags.func_74768_a("progressivebosses:dragon_larva_cooldown", cooldown - 1);
            return;
        }
        BlockPos centerPodium = dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
        AxisAlignedBB bb = new AxisAlignedBB(centerPodium).func_186662_g(96.0);
        List players = world.func_225317_b(ServerPlayerEntity.class, bb);
        if (players.isEmpty()) {
            return;
        }
        int minCooldown = this.minCooldown;
        int maxCooldown = this.maxCooldown;
        cooldown = RandomHelper.getInt((Random)world.field_73012_v, (int)minCooldown, (int)maxCooldown);
        dragonTags.func_74768_a("progressivebosses:dragon_larva_cooldown", cooldown - 1);
        int larvaSpawnedCount = 0;
        int i = this.larvaAtDifficulty;
        while ((float)i <= difficulty) {
            float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            float x = (float)Math.floor(Math.cos(angle) * (double)3.33f);
            float z = (float)Math.floor(Math.sin(angle) * (double)3.33f);
            int y = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos((double)x, 255.0, (double)z)).func_177956_o();
            EndermiteEntity endermite = this.summonLarva(world, new Vector3d((double)x + 0.5, (double)y, (double)z + 0.5), difficulty);
            if (++larvaSpawnedCount >= this.maxSpawned) break;
            i += this.bonusLarvaEveryDifficulty;
        }
    }

    private static void setLarvaAI(EndermiteEntity endermite) {
        ArrayList<Goal> toRemove = new ArrayList<Goal>();
        endermite.field_70715_bh.field_220892_d.forEach(goal -> {
            if (goal.func_220772_j() instanceof NearestAttackableTargetGoal) {
                toRemove.add(goal.func_220772_j());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)endermite.field_70715_bh).func_85156_a(arg_0));
        endermite.field_70715_bh.func_75776_a(2, (Goal)new PBNearestAttackableTargetGoal((MobEntity)endermite));
    }

    public EndermiteEntity summonLarva(World world, Vector3d pos, float difficulty) {
        EndermiteEntity endermite = new EndermiteEntity(EntityType.field_200804_r, world);
        CompoundNBT minionTags = endermite.getPersistentData();
        minionTags.func_74757_a("progressivebosses:dragon_larva", true);
        minionTags.func_74757_a("mobspropertiesrandomness:processed", true);
        endermite.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        endermite.func_200203_b((ITextComponent)new TranslationTextComponent("progressivebosses:dragon_larva"));
        endermite.field_184659_bA = LootTables.field_186419_a;
        endermite.func_110163_bv();
        MCUtils.applyModifier((LivingEntity)endermite, (Attribute)Attributes.field_233819_b_, (UUID)Strings.AttributeModifiers.FOLLOW_RANGE_BONUS_UUID, (String)"progressivebosses:follow_range_bonus", (double)64.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        MCUtils.applyModifier((LivingEntity)endermite, (Attribute)Attributes.field_233821_d_, (UUID)Strings.AttributeModifiers.MOVEMENT_SPEED_BONUS_UUID, (String)"progressivebosses:movement_speed_bonus", (double)0.65, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        MCUtils.applyModifier((LivingEntity)endermite, (Attribute)Attributes.field_233818_a_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)-0.5, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        MCUtils.applyModifier((LivingEntity)endermite, (Attribute)Attributes.field_233823_f_, (UUID)Strings.AttributeModifiers.ATTACK_DAMAGE_BONUS_UUID, (String)"progressivebosses:attack_damage_bonus", (double)(0.35 * (double)difficulty), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        MCUtils.applyModifier((LivingEntity)endermite, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)Strings.AttributeModifiers.SWIM_SPEED_BONUS_UUID, (String)"progressivebosses:swim_speed_bonus", (double)3.0, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        world.func_217376_c((Entity)endermite);
        return endermite;
    }

    @SubscribeEvent
    public void onLarvaHurt(LivingAttackEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.dragonImmune) {
            return;
        }
        if (!(event.getEntity() instanceof EndermiteEntity)) {
            return;
        }
        EndermiteEntity endermite = (EndermiteEntity)event.getEntity();
        CompoundNBT compoundNBT = endermite.getPersistentData();
        if (!compoundNBT.func_74764_b("progressivebosses:dragon_larva")) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof EnderDragonEntity || event.getSource().func_76364_f() instanceof EnderDragonEntity) {
            event.setCanceled(true);
        }
    }
}

