/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.progressivebosses.base.Strings;
import insane96mcp.progressivebosses.setup.Config;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Health", description="Bonus Health and Bonus regeneration.")
public class HealthFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusPerDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maximumBonusRegenConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusRegenPerDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusCrystalRegenConfig;
    public double bonusPerDifficulty = 34.4;
    public double maxBonusRegen = 1.0;
    public double bonusRegenPerDifficulty = 0.05;
    public double bonusCrystalRegen = 0.05;

    public HealthFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusPerDifficultyConfig = Config.builder.comment("Increase Ender Dragon's Health by this value per difficulty").defineInRange("Health Bonus per Difficulty", this.bonusPerDifficulty, 0.0, Double.MAX_VALUE);
        this.maximumBonusRegenConfig = Config.builder.comment("Maximum bonus regeneration per second given by \"Bonus Regeneration per Difficulty\". Set to 0 to disable bonus health regeneration. This doesn't affect the crystal regeneration of the Ender Dragon.").defineInRange("Maximum Bonus Regeneration", this.maxBonusRegen, 0.0, Double.MAX_VALUE);
        this.bonusRegenPerDifficultyConfig = Config.builder.comment("How much health will the Ender Dragon regen per difficulty. This is added to the noaml Crystal regeneration.").defineInRange("Bonus Regeneration per Difficulty", this.bonusRegenPerDifficulty, 0.0, Double.MAX_VALUE);
        this.bonusCrystalRegenConfig = Config.builder.comment("How much health will the Ender Dragon regen per difficulty each second whenever she's attached to a Crystal. This is added to the normal Crystal regen.").defineInRange("Bonus Crystal Regeneration", this.bonusCrystalRegen, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusPerDifficulty = (Double)this.bonusPerDifficultyConfig.get();
        this.maxBonusRegen = (Double)this.maximumBonusRegenConfig.get();
        this.bonusRegenPerDifficulty = (Double)this.bonusRegenPerDifficultyConfig.get();
        this.bonusCrystalRegen = (Double)this.bonusCrystalRegenConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.bonusPerDifficulty == 0.0) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity enderDragon = (EnderDragonEntity)event.getEntity();
        if (enderDragon.func_110148_a(Attributes.field_233818_a_).func_111127_a(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
            return;
        }
        CompoundNBT dragonTags = enderDragon.getPersistentData();
        double difficulty = dragonTags.func_74760_g("progressivebosses:difficulty");
        MCUtils.applyModifier((LivingEntity)enderDragon, (Attribute)Attributes.field_233818_a_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)(difficulty * this.bonusPerDifficulty), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        float crystalBonusHeal;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity enderDragon = (EnderDragonEntity)event.getEntity();
        if (!enderDragon.func_70089_S() || enderDragon.func_184670_cT().func_188756_a().func_188652_i() == PhaseType.field_188750_j) {
            return;
        }
        CompoundNBT tags = enderDragon.getPersistentData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        float flatBonusHeal = this.getFlatBonusHeal(difficulty);
        float heal = flatBonusHeal + (crystalBonusHeal = this.getCrystalBonusHeal(enderDragon, difficulty));
        if (heal == 0.0f) {
            return;
        }
        enderDragon.func_70691_i(heal /= 20.0f);
    }

    private float getFlatBonusHeal(float difficulty) {
        if (this.bonusRegenPerDifficulty == 0.0 || this.maxBonusRegen == 0.0) {
            return 0.0f;
        }
        return (float)Math.min((double)difficulty * this.bonusRegenPerDifficulty, this.maxBonusRegen);
    }

    private float getCrystalBonusHeal(EnderDragonEntity enderDragon, float difficulty) {
        if (this.bonusCrystalRegen == 0.0) {
            return 0.0f;
        }
        if (enderDragon.field_70992_bH == null || !enderDragon.field_70992_bH.func_70089_S()) {
            return 0.0f;
        }
        return (float)(this.bonusCrystalRegen * (double)difficulty);
    }
}

