/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.items.ItemRangeVisualizer;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketClient {
    private int type;
    private CompoundNBT data;

    public PacketClient(int type, CompoundNBT data) {
        this.type = type;
        this.data = data;
    }

    private PacketClient() {
    }

    public static PacketClient fromBytes(PacketBuffer buf) {
        PacketClient client = new PacketClient();
        client.type = buf.readByte();
        client.data = buf.func_150793_b();
        return client;
    }

    public static void toBytes(PacketClient packet, PacketBuffer buf) {
        buf.writeByte(packet.type);
        buf.func_150786_a(packet.data);
    }

    public static void onMessage(final PacketClient message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71441_e != null) {
                    switch (message.type) {
                        case 0: {
                            ResourceLocation goalDim = new ResourceLocation(message.data.func_74779_i("dim"));
                            BlockPos goalPos = BlockPos.func_218283_e((long)message.data.func_74763_f("pos"));
                            ItemRangeVisualizer.visualize((PlayerEntity)mc.field_71439_g, ItemRangeVisualizer.VISUALIZED_RAILS, goalDim, goalPos);
                        }
                        case 1: {
                            Entity entity = mc.field_71441_e.func_73045_a(message.data.func_74762_e("id"));
                            mc.field_71452_i.func_199281_a(entity, (IParticleData)ParticleTypes.field_197604_O, 30);
                            mc.field_71441_e.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_191263_gW, entity.func_184176_by(), 1.0f, 1.0f, false);
                            if (entity != mc.field_71439_g) break;
                            mc.field_71460_t.func_190565_a(new ItemStack((IItemProvider)ModItems.DEATH_RING));
                        }
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

