/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemPetReviver
extends ItemImpl {
    public ItemPetReviver() {
        super("pet_reviver");
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (entity.field_70170_p.field_72995_K || entity.field_70170_p.func_82737_E() % 20L != 0L || !(entity instanceof TameableEntity)) {
                return;
            }
            TameableEntity tameable = (TameableEntity)entity;
            if (!tameable.func_70909_n() || !tameable.getPersistentData().func_74767_n("naturesaura:pet_reviver")) {
                return;
            }
            LivingEntity owner = tameable.func_70902_q();
            if (owner == null || owner.func_70068_e((Entity)tameable) > 25.0) {
                return;
            }
            if (entity.field_70170_p.field_73012_v.nextFloat() >= 0.65f) {
                ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, entity.func_226277_ct_() + entity.field_70170_p.field_73012_v.nextGaussian() * 0.25, entity.func_226280_cw_() + entity.field_70170_p.field_73012_v.nextGaussian() * 0.25, entity.func_226281_cx_() + entity.field_70170_p.field_73012_v.nextGaussian() * 0.25, entity.field_70170_p.field_73012_v.nextInt(2) + 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        @SubscribeEvent
        public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
            Entity target = event.getTarget();
            if (!(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n()) {
                return;
            }
            if (target.getPersistentData().func_74767_n("naturesaura:pet_reviver")) {
                return;
            }
            ItemStack stack = event.getPlayer().func_184586_b(event.getHand());
            if (stack.func_77973_b() != ModItems.PET_REVIVER) {
                return;
            }
            target.getPersistentData().func_74757_a("naturesaura:pet_reviver", true);
            if (!target.field_70170_p.field_72995_K) {
                stack.func_190918_g(1);
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onLivingDeath(LivingDeathEvent event) {
            boolean b;
            float f;
            Optional bed;
            ServerPlayerEntity player;
            BlockPos pos;
            LivingEntity entity = event.getEntityLiving();
            if (entity.field_70170_p.field_72995_K || !(entity instanceof TameableEntity)) {
                return;
            }
            TameableEntity tameable = (TameableEntity)entity;
            if (!tameable.func_70909_n() || !tameable.getPersistentData().func_74767_n("naturesaura:pet_reviver")) {
                return;
            }
            ServerWorld spawnWorld = tameable.field_70170_p.func_73046_m().func_241755_D_();
            Vector3d spawn = Vector3d.func_237492_c_((Vector3i)spawnWorld.func_241135_u_());
            LivingEntity owner = tameable.func_70902_q();
            if (owner instanceof ServerPlayerEntity && (pos = (player = (ServerPlayerEntity)owner).func_241140_K_()) != null && (bed = PlayerEntity.func_242374_a((ServerWorld)((ServerWorld)player.field_70170_p), (BlockPos)pos, (float)(f = player.func_242109_L()), (boolean)(b = player.func_241142_M_()), (boolean)false)).isPresent()) {
                spawnWorld = (ServerWorld)player.field_70170_p;
                spawn = (Vector3d)bed.get();
            }
            PacketHandler.sendToAllAround(tameable.field_70170_p, tameable.func_233580_cy_(), 32, new PacketParticles((float)tameable.func_226277_ct_(), (float)tameable.func_226280_cw_(), (float)tameable.func_226281_cx_(), PacketParticles.Type.PET_REVIVER, 12731933));
            TameableEntity spawnedPet = tameable;
            if (tameable.field_70170_p != spawnWorld) {
                ((ServerWorld)tameable.field_70170_p).removeEntity((Entity)tameable, true);
                spawnedPet = (TameableEntity)tameable.func_200600_R().func_200721_a((World)spawnWorld);
            }
            spawnedPet.func_180432_n((Entity)tameable);
            spawnedPet.func_213293_j(0.0, 0.0, 0.0);
            spawnedPet.func_70012_b(spawn.field_72450_a, spawn.field_72448_b, spawn.field_72449_c, tameable.field_70177_z, tameable.field_70125_A);
            while (!spawnWorld.func_226669_j_((Entity)spawnedPet)) {
                spawnedPet.func_70107_b(spawnedPet.func_226277_ct_(), spawnedPet.func_226278_cu_() + 1.0, spawnedPet.func_226281_cx_());
            }
            spawnedPet.func_70606_j(spawnedPet.func_110138_aP());
            spawnedPet.func_70661_as().func_75499_g();
            spawnedPet.func_233687_w_(true);
            spawnedPet.func_70637_d(false);
            spawnedPet.func_70624_b(null);
            if (tameable.field_70170_p != spawnWorld) {
                spawnWorld.func_217376_c((Entity)spawnedPet);
                tameable.remove(false);
            }
            BlockPos auraPos = IAuraChunk.getHighestSpot((IWorld)spawnWorld, spawnedPet.func_233580_cy_(), 35, spawnedPet.func_233580_cy_());
            IAuraChunk.getAuraChunk((IWorld)spawnWorld, auraPos).drainAura(auraPos, 200000);
            PacketHandler.sendToAllAround(spawnedPet.field_70170_p, spawnedPet.func_233580_cy_(), 32, new PacketParticles((float)spawnedPet.func_226277_ct_(), (float)spawnedPet.func_226280_cw_(), (float)spawnedPet.func_226281_cx_(), PacketParticles.Type.PET_REVIVER, 5093935));
            if (owner instanceof PlayerEntity) {
                owner.func_145747_a((ITextComponent)new TranslationTextComponent("info.naturesaura.pet_reviver", new Object[]{spawnedPet.func_145748_c_()}).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}), UUID.randomUUID());
            }
            event.setCanceled(true);
        }
    }
}

