/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class SpreadEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "spread");

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        int moved;
        int toMove;
        if (Math.abs(spot) < 500000 || Math.abs(IAuraChunk.getAuraInArea((IWorld)world, pos, 25)) < 2000000) {
            return;
        }
        boolean drain = spot > 0;
        int perSide = toMove / 6;
        for (toMove = MathHelper.func_76123_f((float)((float)Math.abs(spot) * 0.72f)); toMove > 0; toMove -= moved) {
            BlockPos bestOffset = null;
            int bestAmount = drain ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            for (Direction facing : Direction.values()) {
                BlockPos offset = pos.func_177967_a(facing, 15);
                if (!world.func_175667_e(offset) || offset.func_177956_o() < 0 || offset.func_177956_o() > world.func_217301_I()) continue;
                int amount = IAuraChunk.getAuraInArea((IWorld)world, offset, 14);
                if (!(drain ? amount < bestAmount : amount > bestAmount)) continue;
                bestAmount = amount;
                bestOffset = offset;
            }
            if (bestOffset == null) break;
            BlockPos bestPos = drain ? IAuraChunk.getLowestSpot((IWorld)world, bestOffset, 14, bestOffset) : IAuraChunk.getHighestSpot((IWorld)world, bestOffset, 14, bestOffset);
            IAuraChunk bestChunk = IAuraChunk.getAuraChunk((IWorld)world, bestPos);
            if (drain) {
                moved = bestChunk.storeAura(bestPos, perSide);
                auraChunk.drainAura(pos, moved);
                continue;
            }
            moved = bestChunk.drainAura(bestPos, perSide);
            auraChunk.storeAura(pos, moved);
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return true;
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

