/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.EggItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class AnimalEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "animal");
    private int chance;
    private AxisAlignedBB bb;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea((IWorld)world, pos, 30);
        if (aura < 1500000) {
            return false;
        }
        this.chance = Math.min(50, MathHelper.func_76123_f((float)((float)Math.abs(aura) / 500000.0f / (float)IAuraChunk.getSpotAmountInArea((IWorld)world, pos, 30))));
        if (this.chance <= 0) {
            return false;
        }
        int dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 150000), (int)5, (int)35);
        this.bb = new AxisAlignedBB(pos).func_186662_g((double)dist);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(PlayerEntity player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (!this.bb.func_72318_a(player.func_213303_ch())) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (!NaturesAuraAPI.instance().isEffectPowderActive(player.field_70170_p, player.func_233580_cy_(), NAME)) {
            return IDrainSpotEffect.ActiveType.INHIBITED;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((IItemProvider)Items.field_151110_aK);
    }

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (world.func_82737_E() % 200L != 0L) {
            return;
        }
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        List animals = world.func_217357_a(AnimalEntity.class, this.bb);
        if (animals.size() >= (Integer)ModConfig.instance.maxAnimalsAroundPowder.get()) {
            return;
        }
        List items = world.func_217357_a(ItemEntity.class, this.bb);
        for (ItemEntity item : items) {
            int age;
            ItemStack stack;
            if (!item.func_70089_S() || !NaturesAuraAPI.instance().isEffectPowderActive(world, item.func_233580_cy_(), NAME) || !((stack = item.func_92059_d()).func_77973_b() instanceof EggItem) || (age = ((Integer)ObfuscationReflectionHelper.getPrivateValue(ItemEntity.class, (Object)item, (String)"field_70292_b")).intValue()) < item.lifespan / 2) continue;
            if (stack.func_190916_E() <= 1) {
                item.func_70106_y();
            } else {
                stack.func_190918_g(1);
                item.func_92058_a(stack);
            }
            ChickenEntity chicken = new ChickenEntity(EntityType.field_200795_i, world);
            chicken.func_70873_a(-24000);
            chicken.func_70107_b(item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_());
            world.func_217376_c((Entity)chicken);
            BlockPos closestSpot = IAuraChunk.getHighestSpot((IWorld)world, item.func_233580_cy_(), 35, pos);
            IAuraChunk.getAuraChunk((IWorld)world, closestSpot).drainAura(closestSpot, 2000);
        }
        if (world.field_73012_v.nextInt(20) <= this.chance) {
            if (animals.size() < 2) {
                return;
            }
            AnimalEntity first = (AnimalEntity)animals.get(world.field_73012_v.nextInt(animals.size()));
            if (first.func_70631_g_() || first.func_70880_s()) {
                return;
            }
            if (!NaturesAuraAPI.instance().isEffectPowderActive(world, first.func_233580_cy_(), NAME)) {
                return;
            }
            Optional<AnimalEntity> secondOptional = animals.stream().filter(e -> e != first && !e.func_70880_s() && !e.func_70631_g_()).min(Comparator.comparingDouble(e -> e.func_70068_e((Entity)first)));
            if (!secondOptional.isPresent()) {
                return;
            }
            AnimalEntity second = secondOptional.get();
            if (second.func_70068_e((Entity)first) > 25.0) {
                return;
            }
            this.setInLove(first);
            this.setInLove(second);
            BlockPos closestSpot = IAuraChunk.getHighestSpot((IWorld)world, first.func_233580_cy_(), 35, pos);
            IAuraChunk.getAuraChunk((IWorld)world, closestSpot).drainAura(closestSpot, 3500);
        }
    }

    private void setInLove(AnimalEntity animal) {
        animal.func_146082_f(null);
        for (int j = 0; j < 7; ++j) {
            animal.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, animal.func_226277_ct_() + (double)(animal.field_70170_p.field_73012_v.nextFloat() * animal.func_213311_cf() * 2.0f) - (double)animal.func_213311_cf(), animal.func_226278_cu_() + 0.5 + (double)(animal.field_70170_p.field_73012_v.nextFloat() * animal.func_213302_cg()), animal.func_226281_cx_() + (double)(animal.field_70170_p.field_73012_v.nextFloat() * animal.func_213311_cf() * 2.0f) - (double)animal.func_213311_cf(), animal.field_70170_p.field_73012_v.nextGaussian() * 0.02, animal.field_70170_p.field_73012_v.nextGaussian() * 0.02, animal.field_70170_p.field_73012_v.nextGaussian() * 0.02);
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.animalEffect.get();
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

