/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityImpl
extends TileEntity {
    public int redstonePower;
    private LazyOptional<IItemHandler> itemHandler;
    private LazyOptional<IAuraContainer> auraContainer;

    public TileEntityImpl(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeNBT(compound, SaveType.TILE);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.readNBT(compound, SaveType.TILE);
    }

    public void writeNBT(CompoundNBT compound, SaveType type) {
        if (type != SaveType.BLOCK) {
            super.func_189515_b(compound);
            compound.func_74768_a("redstone", this.redstonePower);
        }
    }

    public void readNBT(CompoundNBT compound, SaveType type) {
        if (type != SaveType.BLOCK) {
            super.func_230337_a_(null, compound);
            this.redstonePower = compound.func_74762_e("redstone");
        }
    }

    public void onRedstonePowerChange(int newPower) {
        this.redstonePower = newPower;
    }

    public final SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        this.writeNBT(compound, SaveType.SYNC);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, compound);
    }

    public final CompoundNBT func_189517_E_() {
        CompoundNBT compound = new CompoundNBT();
        this.writeNBT(compound, SaveType.SYNC);
        return compound;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.readNBT(tag, SaveType.SYNC);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        this.readNBT(packet.func_148857_g(), SaveType.SYNC);
    }

    public void sendToClients() {
        ServerWorld world = (ServerWorld)this.func_145831_w();
        Stream entities = world.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(this.func_174877_v()), false);
        SUpdateTileEntityPacket packet = this.func_189518_D_();
        entities.forEach(e -> e.field_71135_a.func_147359_a((IPacket)packet));
    }

    public IItemHandlerModifiable getItemHandler() {
        return null;
    }

    public IAuraContainer getAuraContainer() {
        return null;
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemHandler == null) {
                IItemHandlerModifiable handler = this.getItemHandler();
                this.itemHandler = handler == null ? LazyOptional.empty() : LazyOptional.of(() -> TileEntityImpl.lambda$getCapability$1((IItemHandler)handler));
            }
            return this.itemHandler.cast();
        }
        if (capability == NaturesAuraAPI.capAuraContainer) {
            if (this.auraContainer == null) {
                IAuraContainer container = this.getAuraContainer();
                this.auraContainer = container == null ? LazyOptional.empty() : LazyOptional.of(() -> container);
            }
            return this.auraContainer.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
        }
        if (this.auraContainer != null) {
            this.auraContainer.invalidate();
        }
    }

    public void dropInventory() {
        IItemHandlerModifiable handler = this.getItemHandler();
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ItemEntity item = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
                this.field_145850_b.func_217376_c((Entity)item);
            }
        }
    }

    public void modifyDrop(ItemStack regularItem) {
        CompoundNBT compound = new CompoundNBT();
        this.writeNBT(compound, SaveType.BLOCK);
        if (!compound.isEmpty()) {
            if (!regularItem.func_77942_o()) {
                regularItem.func_77982_d(new CompoundNBT());
            }
            regularItem.func_77978_p().func_218657_a("data", (INBT)compound);
        }
    }

    public void loadDataOnPlace(ItemStack stack) {
        CompoundNBT compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p().func_74775_l("data")) != null) {
            this.readNBT(compound, SaveType.BLOCK);
        }
    }

    public boolean canGenerateRightNow(int toAdd) {
        BlockState below;
        if (this.wantsLimitRemover() && (below = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())).func_177230_c() == ModBlocks.GENERATOR_LIMIT_REMOVER) {
            return true;
        }
        int aura = IAuraChunk.getAuraInArea((IWorld)this.field_145850_b, this.field_174879_c, 35);
        return aura + toAdd <= 2000000;
    }

    public boolean wantsLimitRemover() {
        return false;
    }

    public void generateAura(int amount) {
        while (amount > 0) {
            BlockPos spot = IAuraChunk.getLowestSpot((IWorld)this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
            amount -= IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, spot).storeAura(spot, amount);
        }
    }

    private static /* synthetic */ IItemHandler lambda$getCapability$1(IItemHandler handler) {
        return handler;
    }

    public static enum SaveType {
        TILE,
        SYNC,
        BLOCK;

    }
}

