/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityPickupStopper;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockPickupStopper
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState {
    public BlockPickupStopper() {
        super("pickup_stopper", TileEntityPickupStopper::new, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f).func_200947_a(SoundType.field_185851_d));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player != null && !player.func_225608_bj_()) {
            ItemEntity item = event.getItem();
            BlockPos pos = item.func_233580_cy_();
            Helper.getTileEntitiesInArea((IWorld)item.field_70170_p, pos, 8, tile -> {
                if (!(tile instanceof TileEntityPickupStopper)) {
                    return false;
                }
                TileEntityPickupStopper stopper = (TileEntityPickupStopper)((Object)tile);
                float radius = stopper.getRadius();
                if (radius <= 0.0f) {
                    return false;
                }
                BlockPos stopperPos = stopper.func_174877_v();
                if (!new AxisAlignedBB(stopperPos).func_186662_g((double)radius).func_72326_a(item.func_174813_aQ())) {
                    return false;
                }
                event.setCanceled(true);
                if (item.field_70170_p.func_82737_E() % 3L == 0L) {
                    PacketHandler.sendToAllAround(item.field_70170_p, pos, 32, new PacketParticles((float)item.func_226277_ct_(), (float)item.func_226278_cu_(), (float)item.func_226281_cx_(), PacketParticles.Type.PICKUP_STOPPER, new int[0]));
                }
                return true;
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        double radius;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPickupStopper && (radius = (double)((TileEntityPickupStopper)tile).getRadius()) > 0.0) {
            return new AxisAlignedBB(pos).func_186662_g(radius);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return 16034370;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_top"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }
}

