/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.mixin.client;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import me.jaackson.etched.client.sound.AbstractOnlineSoundInstance;
import me.jaackson.etched.client.sound.SoundStopListener;
import me.jaackson.etched.client.sound.download.EmptyAudioStream;
import me.jaackson.etched.client.sound.download.RawAudioStream;
import me.jaackson.etched.client.sound.download.SoundCache;
import me.jaackson.etched.client.sound.format.MonoWrapper;
import me.jaackson.etched.client.sound.format.SeekingStream;
import me.jaackson.etched.client.sound.format.WaveDataReader;
import me.jaackson.etched.client.sound.source.AudioSource;
import me.jaackson.etched.common.item.EtchedMusicDiscItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.AudioStreamManager;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.IAudioStream;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.OggAudioStream;
import net.minecraft.client.audio.OggAudioStreamWrapper;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SoundEngine.class})
public abstract class SoundEngineMixin {
    @Shadow
    @Final
    private static Logger field_148621_b;
    @Unique
    private Sound sound;

    @Inject(method={"tickNonPaused"}, at={@At(value="INVOKE", target="Ljava/util/Map;remove(Ljava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onSoundRemoved(CallbackInfo ci, Iterator<?> iterator, Map.Entry<?, ?> entry, ChannelManager.Entry channelHandle2, ISound soundInstance) {
        if (soundInstance instanceof SoundStopListener) {
            ((SoundStopListener)soundInstance).onStop();
        }
    }

    @Inject(method={"play"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundBufferLibrary;getStream(Lnet/minecraft/resources/ResourceLocation;Z)Ljava/util/concurrent/CompletableFuture;", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void captureSound(ISound soundInstance, CallbackInfo ci, SoundEventAccessor weighedSoundEvents, ResourceLocation resourceLocation, Sound sound) {
        this.sound = sound;
    }

    @Redirect(method={"play"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundBufferLibrary;getStream(Lnet/minecraft/resources/ResourceLocation;Z)Ljava/util/concurrent/CompletableFuture;"))
    public CompletableFuture<IAudioStream> redirectSoundStream(AudioStreamManager soundBufferLibrary, ResourceLocation resourceLocation, boolean loop) {
        if (!(this.sound instanceof AbstractOnlineSoundInstance.OnlineSound)) {
            return soundBufferLibrary.func_217917_b(resourceLocation, loop);
        }
        AbstractOnlineSoundInstance.OnlineSound onlineSound = (AbstractOnlineSoundInstance.OnlineSound)this.sound;
        if (EtchedMusicDiscItem.isLocalSound(onlineSound.getURL())) {
            SoundEventAccessor weighedSoundEvents = Minecraft.func_71410_x().func_147118_V().func_184398_a(new ResourceLocation(onlineSound.getURL()));
            if (weighedSoundEvents == null) {
                throw new CompletionException(new FileNotFoundException("Unable to play unknown soundEvent: " + resourceLocation));
            }
            return ((CompletableFuture)soundBufferLibrary.func_217917_b(weighedSoundEvents.func_148720_g().func_188721_b(), loop).thenApplyAsync(MonoWrapper::new, Util.func_215072_e())).handleAsync((stream, e) -> {
                if (e != null) {
                    e.printStackTrace();
                    onlineSound.getProgressListener().onFail();
                    return EmptyAudioStream.INSTANCE;
                }
                onlineSound.getProgressListener().onSuccess();
                return stream;
            }, Util.func_215072_e());
        }
        return ((CompletableFuture)((CompletableFuture)SoundCache.getAudioStream(onlineSound.getURL(), onlineSound.getProgressListener()).thenComposeAsync(AudioSource::openStream)).thenApplyAsync(is -> {
            onlineSound.getProgressListener().progressStartLoading();
            try {
                try {
                    return new MonoWrapper((IAudioStream)(loop ? new OggAudioStreamWrapper(OggAudioStream::new, is) : new OggAudioStream(is)));
                }
                catch (Exception e) {
                    field_148621_b.debug("Failed to load as OGG", (Throwable)e);
                    ((SeekingStream)((Object)is)).beginning();
                    try {
                        AudioInputStream ais = WaveDataReader.getAudioInputStream(is);
                        AudioFormat format = ais.getFormat();
                        return new MonoWrapper((IAudioStream)(loop ? new OggAudioStreamWrapper(input -> new RawAudioStream(format, input), (InputStream)ais) : new RawAudioStream(format, ais)));
                    }
                    catch (Exception e1) {
                        field_148621_b.debug("Failed to load as WAV", (Throwable)e1);
                        ((SeekingStream)((Object)is)).beginning();
                        try {
                            me.jaackson.etched.lib.javamp3.Sound sound = new me.jaackson.etched.lib.javamp3.Sound(new BufferedInputStream((InputStream)is));
                            AudioFormat format = sound.getAudioFormat();
                            return new MonoWrapper((IAudioStream)(loop ? new OggAudioStreamWrapper(input -> new RawAudioStream(format, input), (InputStream)sound) : new RawAudioStream(format, sound)));
                        }
                        catch (Exception e2) {
                            field_148621_b.debug("Failed to load as MP3", (Throwable)e2);
                            IOUtils.closeQuietly((InputStream)is);
                            e.printStackTrace();
                            e1.printStackTrace();
                            e2.printStackTrace();
                            throw new CompletionException(new UnsupportedAudioFileException("Could not load as OGG, WAV, OR MP3"));
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }, Util.func_215072_e())).handleAsync((stream, e) -> {
            if (e != null) {
                e.printStackTrace();
                onlineSound.getProgressListener().onFail();
                return EmptyAudioStream.INSTANCE;
            }
            onlineSound.getProgressListener().onSuccess();
            return stream;
        }, Util.func_215072_e());
    }
}

