/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.common.network.handler;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import me.jaackson.etched.EtchedRegistry;
import me.jaackson.etched.client.screen.EtchingScreen;
import me.jaackson.etched.client.sound.JukeboxMinecartSoundInstance;
import me.jaackson.etched.client.sound.OnlineRecordSoundInstance;
import me.jaackson.etched.client.sound.StopListeningSound;
import me.jaackson.etched.client.sound.download.DownloadProgressListener;
import me.jaackson.etched.common.block.AlbumJukeboxBlock;
import me.jaackson.etched.common.blockentity.AlbumJukeboxBlockEntity;
import me.jaackson.etched.common.entity.MinecartJukebox;
import me.jaackson.etched.common.item.EtchedMusicDiscItem;
import me.jaackson.etched.common.network.ClientboundAddMinecartJukeboxPacket;
import me.jaackson.etched.common.network.ClientboundInvalidEtchUrlPacket;
import me.jaackson.etched.common.network.ClientboundPlayMinecartJukeboxMusicPacket;
import me.jaackson.etched.common.network.ClientboundPlayMusicPacket;
import me.jaackson.etched.mixin.client.GuiAccessor;
import me.jaackson.etched.mixin.client.LevelRendererAccessor;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MinecartTickableSound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EtchedClientPlayHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Int2ObjectArrayMap<ISound> ENTITY_PLAYING_SOUNDS = new Int2ObjectArrayMap();

    public static void handlePlayMusicPacket(ClientboundPlayMusicPacket pkt) {
        BlockPos pos;
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return;
        }
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        Map<BlockPos, ISound> playingRecords = ((LevelRendererAccessor)Minecraft.func_71410_x().field_71438_f).getPlayingRecords();
        ISound soundInstance = playingRecords.get(pos = pkt.getPos());
        if (soundInstance != null) {
            soundManager.func_147683_b(soundInstance);
            playingRecords.remove(pos);
        }
        if (!EtchedMusicDiscItem.isValidURL(pkt.getUrl())) {
            LOGGER.error("Server sent invalid music URL: " + pkt.getUrl());
            return;
        }
        EtchedClientPlayHandler.playRecord(pos, new StopListeningSound(EtchedClientPlayHandler.getEtchedRecord(pkt.getUrl(), pkt.getTitle(), level, pos), () -> Minecraft.func_71410_x().func_212871_a_(() -> {
            if (level.func_180495_p(pos).func_203425_a(Blocks.field_150421_aI)) {
                for (LivingEntity livingEntity : level.func_217357_a(LivingEntity.class, new AxisAlignedBB(pos).func_186662_g(3.0))) {
                    livingEntity.func_191987_a(pos, false);
                }
            }
        })));
    }

    public static void handleAddMinecartJukeboxPacket(ClientboundAddMinecartJukeboxPacket pkt) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return;
        }
        MinecartJukebox entity = new MinecartJukebox((World)level, pkt.getX(), pkt.getY(), pkt.getZ());
        int i = pkt.getId();
        entity.func_213312_b(pkt.getX(), pkt.getY(), pkt.getZ());
        entity.func_225653_b_(pkt.getX(), pkt.getY(), pkt.getZ());
        entity.field_70125_A = (float)(pkt.getxRot() * 360) / 256.0f;
        entity.field_70177_z = (float)(pkt.getyRot() * 360) / 256.0f;
        entity.func_145769_d(i);
        entity.func_184221_a(pkt.getUUID());
        level.func_217411_a(i, (Entity)entity);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MinecartTickableSound((AbstractMinecartEntity)entity));
    }

    public static void handlePlayMinecartJukeboxPacket(ClientboundPlayMinecartJukeboxMusicPacket pkt) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return;
        }
        int entityId = pkt.getEntityId();
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        ISound soundInstance = (ISound)ENTITY_PLAYING_SOUNDS.get(entityId);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            if (pkt.getAction() == ClientboundPlayMinecartJukeboxMusicPacket.Action.RESTART && soundManager.func_215294_c(soundInstance)) {
                return;
            }
            soundManager.func_147683_b(soundInstance);
            ENTITY_PLAYING_SOUNDS.remove(entityId);
        }
        if (pkt.getAction() == ClientboundPlayMinecartJukeboxMusicPacket.Action.STOP) {
            return;
        }
        Entity entity = level.func_73045_a(pkt.getEntityId());
        if (!(entity instanceof MinecartJukebox)) {
            return;
        }
        if (pkt.getUrl() != null) {
            if (!EtchedMusicDiscItem.isValidURL(pkt.getUrl())) {
                LOGGER.error("Server sent invalid music URL: " + pkt.getUrl());
                return;
            }
            ISound sound = EtchedClientPlayHandler.getEtchedRecord(pkt.getUrl(), pkt.getTitle(), (MinecartJukebox)entity);
            ENTITY_PLAYING_SOUNDS.put(entityId, (Object)sound);
            soundManager.func_147682_a(sound);
        } else {
            Item record = (Item)Registry.field_212630_s.func_148745_a(pkt.getRecordId());
            if (!(record instanceof MusicDiscItem)) {
                LOGGER.error("Server sent invalid music disc: " + record);
                return;
            }
            if (EtchedClientPlayHandler.canShowMessage(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_())) {
                Minecraft.func_71410_x().field_71456_v.func_238451_a_((ITextComponent)((MusicDiscItem)record).func_234801_g_());
            }
            JukeboxMinecartSoundInstance sound = new JukeboxMinecartSoundInstance(((MusicDiscItem)record).func_185075_h(), (MinecartJukebox)entity);
            ENTITY_PLAYING_SOUNDS.put(entityId, (Object)sound);
            soundManager.func_147682_a((ISound)sound);
        }
    }

    public static void handleSetInvalidEtch(ClientboundInvalidEtchUrlPacket pkt) {
        if (Minecraft.func_71410_x().field_71462_r instanceof EtchingScreen) {
            EtchingScreen screen = (EtchingScreen)Minecraft.func_71410_x().field_71462_r;
            screen.setReason(pkt.getException());
        }
    }

    private static boolean canShowMessage(double x, double y, double z) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return player == null || player.func_70092_e(x, y, z) <= 4096.0;
    }

    private static ISound getEtchedRecord(String url, final ITextComponent title, final MinecartJukebox jukebox) {
        return new OnlineRecordSoundInstance(url, jukebox, new MusicDownloadListener(title, () -> ((MinecartJukebox)jukebox).func_226277_ct_(), () -> ((MinecartJukebox)jukebox).func_226278_cu_(), () -> ((MinecartJukebox)jukebox).func_226281_cx_()){

            @Override
            public void onSuccess() {
                if (!jukebox.func_70089_S() || !ENTITY_PLAYING_SOUNDS.containsKey(jukebox.func_145782_y())) {
                    this.clearComponent();
                } else if (EtchedClientPlayHandler.canShowMessage(jukebox.func_226277_ct_(), jukebox.func_226278_cu_(), jukebox.func_226281_cx_())) {
                    Minecraft.func_71410_x().field_71456_v.func_238451_a_(title);
                }
            }
        });
    }

    private static ISound getEtchedRecord(String url, final ITextComponent title, final ClientWorld level, final BlockPos pos) {
        final Map<BlockPos, ISound> playingRecords = ((LevelRendererAccessor)Minecraft.func_71410_x().field_71438_f).getPlayingRecords();
        return new OnlineRecordSoundInstance(url, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (DownloadProgressListener)new MusicDownloadListener(title, () -> (double)pos.func_177958_n() + 0.5, () -> (double)pos.func_177956_o() + 0.5, () -> (double)pos.func_177952_p() + 0.5){

            @Override
            public void onSuccess() {
                if (!playingRecords.containsKey(pos)) {
                    this.clearComponent();
                } else {
                    if (EtchedClientPlayHandler.canShowMessage((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5)) {
                        Minecraft.func_71410_x().field_71456_v.func_238451_a_(title);
                    }
                    if (level.func_180495_p(pos).func_203425_a(Blocks.field_150421_aI)) {
                        for (LivingEntity livingEntity : level.func_217357_a(LivingEntity.class, new AxisAlignedBB(pos).func_186662_g(3.0))) {
                            livingEntity.func_191987_a(pos, true);
                        }
                    }
                }
            }
        });
    }

    private static void playRecord(BlockPos pos, ISound sound) {
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        Map<BlockPos, ISound> playingRecords = ((LevelRendererAccessor)Minecraft.func_71410_x().field_71438_f).getPlayingRecords();
        playingRecords.put(pos, sound);
        soundManager.func_147682_a(sound);
    }

    private static void playNextRecord(ClientWorld level, BlockPos pos) {
        TileEntity blockEntity = level.func_175625_s(pos);
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity)) {
            return;
        }
        AlbumJukeboxBlockEntity jukebox = (AlbumJukeboxBlockEntity)blockEntity;
        jukebox.next();
        EtchedClientPlayHandler.playAlbum((AlbumJukeboxBlockEntity)blockEntity, level, pos, true);
    }

    public static void playAlbum(AlbumJukeboxBlockEntity jukebox, ClientWorld level, BlockPos pos, boolean force) {
        EtchedMusicDiscItem.MusicInfo music;
        Optional<EtchedMusicDiscItem.MusicInfo> optional;
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        Map<BlockPos, ISound> playingRecords = ((LevelRendererAccessor)Minecraft.func_71410_x().field_71438_f).getPlayingRecords();
        if (!(((Boolean)level.func_180495_p(pos).func_177229_b((Property)AlbumJukeboxBlock.POWERED)).booleanValue() || jukebox.recalculatePlayingIndex() || force)) {
            return;
        }
        ISound soundInstance = playingRecords.get(pos);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            soundManager.func_147683_b(soundInstance);
            playingRecords.remove(pos);
        }
        if (((Boolean)level.func_180495_p(pos).func_177229_b((Property)AlbumJukeboxBlock.POWERED)).booleanValue()) {
            jukebox.stopPlaying();
        }
        if (jukebox.getPlayingIndex() < 0) {
            return;
        }
        ItemStack disc = jukebox.func_70301_a(jukebox.getPlayingIndex());
        StopListeningSound sound = null;
        if (disc.func_77973_b() == EtchedRegistry.ETCHED_MUSIC_DISC.get() && (optional = EtchedMusicDiscItem.getMusic(disc)).isPresent() && EtchedMusicDiscItem.isValidURL((music = optional.get()).getUrl())) {
            sound = new StopListeningSound(EtchedClientPlayHandler.getEtchedRecord(music.getUrl(), music.getDisplayName(), level, pos), () -> Minecraft.func_71410_x().func_212871_a_(() -> EtchedClientPlayHandler.playNextRecord(level, pos)));
        }
        if (disc.func_77973_b() instanceof MusicDiscItem) {
            if (EtchedClientPlayHandler.canShowMessage((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5)) {
                Minecraft.func_71410_x().field_71456_v.func_238451_a_((ITextComponent)((MusicDiscItem)disc.func_77973_b()).func_234801_g_());
            }
            sound = new StopListeningSound((ISound)SimpleSound.func_184372_a((SoundEvent)((MusicDiscItem)disc.func_77973_b()).func_185075_h(), (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5)), () -> Minecraft.func_71410_x().func_212871_a_(() -> EtchedClientPlayHandler.playNextRecord(level, pos)));
        }
        if (sound == null) {
            return;
        }
        EtchedClientPlayHandler.playRecord(pos, sound);
        if (disc.func_77973_b() instanceof MusicDiscItem && level.func_180495_p(pos).func_203425_a(Blocks.field_150421_aI)) {
            for (LivingEntity livingEntity : level.func_217357_a(LivingEntity.class, new AxisAlignedBB(pos).func_186662_g(3.0))) {
                livingEntity.func_191987_a(pos, true);
            }
        }
    }

    private static abstract class MusicDownloadListener
    implements DownloadProgressListener {
        private final ITextComponent title;
        private final DoubleSupplier x;
        private final DoubleSupplier y;
        private final DoubleSupplier z;
        private float size;
        private ITextComponent requesting;
        private DownloadTextComponent component;

        protected MusicDownloadListener(ITextComponent title, DoubleSupplier x, DoubleSupplier y, DoubleSupplier z) {
            this.title = title;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private void setComponent(ITextComponent text) {
            if (!EtchedClientPlayHandler.canShowMessage(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble())) {
                return;
            }
            if (this.component == null) {
                this.component = new DownloadTextComponent();
                Minecraft.func_71410_x().field_71456_v.func_175188_a((ITextComponent)this.component, true);
                ((GuiAccessor)Minecraft.func_71410_x().field_71456_v).setOverlayMessageTime(Short.MAX_VALUE);
            }
            this.component.setText(text.getString());
        }

        protected void clearComponent() {
            if (((GuiAccessor)Minecraft.func_71410_x().field_71456_v).getOverlayMessageString() == this.component) {
                ((GuiAccessor)Minecraft.func_71410_x().field_71456_v).setOverlayMessageTime(60);
                this.component = null;
            }
        }

        @Override
        public void progressStartRequest(ITextComponent component) {
            this.requesting = component;
            this.setComponent(component);
        }

        @Override
        public void progressStartDownload(float size) {
            this.size = size;
            this.requesting = null;
            this.progressStagePercentage(0);
        }

        @Override
        public void progressStagePercentage(int percentage) {
            if (this.requesting != null) {
                this.setComponent((ITextComponent)this.requesting.func_230532_e_().func_240702_b_(" " + percentage + "%"));
            } else if (this.size != 0.0f) {
                this.setComponent((ITextComponent)new TranslationTextComponent("record.etched.downloadProgress", new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf((float)percentage / 100.0f * this.size)), String.format(Locale.ROOT, "%.2f", Float.valueOf(this.size)), this.title}));
            }
        }

        @Override
        public void progressStartLoading() {
            this.requesting = null;
            this.setComponent((ITextComponent)new TranslationTextComponent("record.etched.loading", new Object[]{this.title}));
        }

        @Override
        public void onFail() {
            if (EtchedClientPlayHandler.canShowMessage(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble())) {
                Minecraft.func_71410_x().field_71456_v.func_175188_a((ITextComponent)new TranslationTextComponent("record.etched.downloadFail", new Object[]{this.title}), true);
            }
        }
    }

    public static class DownloadTextComponent
    extends TextComponent {
        private String text = "";
        private IReorderingProcessor visualOrderText;
        private LanguageMap decomposedWith;

        public String func_150261_e() {
            return this.text;
        }

        public StringTextComponent plainCopy() {
            return new StringTextComponent(this.text);
        }

        @OnlyIn(value=Dist.CLIENT)
        public IReorderingProcessor func_241878_f() {
            LanguageMap language = LanguageMap.func_74808_a();
            if (this.decomposedWith != language) {
                this.visualOrderText = language.func_241870_a((ITextProperties)this);
                this.decomposedWith = language;
            }
            return this.visualOrderText;
        }

        public String toString() {
            return "TextComponent{text='" + this.text + '\'' + ", siblings=" + this.field_150264_a + ", style=" + this.func_150256_b() + '}';
        }

        public void setText(String text) {
            this.text = text;
            this.decomposedWith = null;
        }
    }
}

