/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.common.menu;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import me.jaackson.etched.EtchedRegistry;
import me.jaackson.etched.bridge.NetworkBridge;
import me.jaackson.etched.client.sound.download.SoundCloud;
import me.jaackson.etched.common.item.BlankMusicDiscItem;
import me.jaackson.etched.common.item.EtchedMusicDiscItem;
import me.jaackson.etched.common.item.MusicLabelItem;
import me.jaackson.etched.common.network.ClientboundInvalidEtchUrlPacket;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HTTPUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EtchingMenu
extends Container {
    public static final ResourceLocation EMPTY_SLOT_MUSIC_DISC = new ResourceLocation("etched", "item/empty_etching_table_slot_music_disc");
    public static final ResourceLocation EMPTY_SLOT_MUSIC_LABEL = new ResourceLocation("etched", "item/empty_etching_table_slot_music_label");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> VALID_FORMATS;
    private final IWorldPosCallable access;
    private final IntReferenceHolder labelIndex;
    private final Slot discSlot;
    private final Slot labelSlot;
    private final Slot resultSlot;
    private final IInventory input;
    private final IInventory result;
    private final PlayerEntity player;
    private String url;
    private String cachedAuthor;
    private String cachedTitle;
    private int urlId;
    private long lastSoundTime;

    public EtchingMenu(int id, PlayerInventory inventory) {
        this(id, inventory, IWorldPosCallable.field_221489_a);
    }

    public EtchingMenu(int id, PlayerInventory inventory, final IWorldPosCallable containerLevelAccess) {
        super(EtchedRegistry.ETCHING_MENU.get(), id);
        this.player = inventory.field_70458_d;
        this.labelIndex = IntReferenceHolder.func_221492_a();
        this.input = new Inventory(2){

            public void func_70296_d() {
                super.func_70296_d();
                EtchingMenu.this.func_75130_a((IInventory)this);
            }
        };
        this.result = new Inventory(1){

            public void func_70296_d() {
                super.func_70296_d();
            }
        };
        this.access = containerLevelAccess;
        this.discSlot = this.func_75146_a(new Slot(this.input, 0, 44, 43){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == EtchedRegistry.BLANK_MUSIC_DISC.get() || stack.func_77973_b() == EtchedRegistry.ETCHED_MUSIC_DISC.get();
            }

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)EMPTY_SLOT_MUSIC_DISC);
            }
        });
        this.labelSlot = this.func_75146_a(new Slot(this.input, 1, 62, 43){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof MusicLabelItem;
            }

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)EMPTY_SLOT_MUSIC_LABEL);
            }
        });
        this.resultSlot = this.func_75146_a(new Slot(this.result, 0, 116, 43){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
                EtchingMenu.this.discSlot.func_75209_a(1);
                EtchingMenu.this.labelSlot.func_75209_a(1);
                if (!EtchingMenu.this.discSlot.func_75216_d() || !EtchingMenu.this.labelSlot.func_75216_d()) {
                    EtchingMenu.this.labelIndex.func_221494_a(0);
                }
                EtchingMenu.this.setupResultSlot();
                EtchingMenu.this.func_75142_b();
                containerLevelAccess.func_221486_a((level, pos) -> {
                    long l = level.func_82737_E();
                    if (EtchingMenu.this.lastSoundTime != l) {
                        level.func_184133_a(null, pos, EtchedRegistry.UI_ETCHER_TAKE_RESULT.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        EtchingMenu.this.lastSoundTime = l;
                    }
                });
                return super.func_190901_a(player, stack);
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)inventory, x + y * 9 + 9, 8 + x * 18, 98 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)inventory, x, 8 + x * 18, 156));
        }
        this.func_216958_a(this.labelIndex);
    }

    private static Map<String, String> getDownloadHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("X-Minecraft-Version", SharedConstants.func_215069_a().getName());
        map.put("X-Minecraft-Version-ID", SharedConstants.func_215069_a().getId());
        map.put("User-Agent", "Minecraft Java/" + SharedConstants.func_215069_a().getName());
        return map;
    }

    private static void checkStatus(String url) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(url);
            httpURLConnection = (HttpURLConnection)uRL.openConnection(Proxy.NO_PROXY);
            httpURLConnection.setInstanceFollowRedirects(true);
            Map<String, String> map = EtchingMenu.getDownloadHeaders();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (httpURLConnection.getResponseCode() != 200) {
                IOUtils.closeQuietly((InputStream)httpURLConnection.getInputStream());
                throw new IOException(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
            }
            String contentType = httpURLConnection.getContentType();
            if (!VALID_FORMATS.contains(contentType)) {
                throw new IOException("Unsupported Content-Type: " + contentType);
            }
        }
        catch (Throwable e) {
            if (httpURLConnection != null) {
                try {
                    LOGGER.error(IOUtils.toString((InputStream)httpURLConnection.getErrorStream(), (Charset)StandardCharsets.UTF_8));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            throw new IOException(e);
        }
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.access.func_221486_a((level, pos) -> this.func_193327_a(player, (World)level, this.input));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return EtchingMenu.func_216963_a((IWorldPosCallable)this.access, (PlayerEntity)player, (Block)EtchedRegistry.ETCHING_TABLE.get());
    }

    public boolean func_75140_a(PlayerEntity player, int index) {
        if (index >= 0 && index < EtchedMusicDiscItem.LabelPattern.values().length) {
            this.labelIndex.func_221494_a(index);
            this.setupResultSlot();
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack2 = slot.func_75211_c();
            itemStack = itemStack2.func_77946_l();
            if (index < 3 ? !this.func_75135_a(itemStack2, 3, this.field_75151_b.size(), true) : !this.func_75135_a(itemStack2, 0, 3, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemStack2.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemStack2.func_190916_E() == itemStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemStack2);
        }
        return itemStack;
    }

    public void func_75130_a(IInventory container) {
        ItemStack discStack = this.discSlot.func_75211_c();
        ItemStack labelStack = this.labelSlot.func_75211_c();
        ItemStack resultStack = this.resultSlot.func_75211_c();
        if (resultStack.func_190926_b() && labelStack.func_190926_b()) {
            if (!discStack.func_190926_b() && discStack.func_77973_b() == EtchedRegistry.ETCHED_MUSIC_DISC.get()) {
                this.labelIndex.func_221494_a(EtchedMusicDiscItem.getPattern(discStack).ordinal());
            } else {
                this.labelIndex.func_221494_a(0);
            }
        }
        this.setupResultSlot();
        this.func_75142_b();
    }

    private void setupResultSlot() {
        if (!this.player.field_70170_p.func_201670_d()) {
            NetworkBridge.sendToPlayer((ServerPlayerEntity)this.player, new ClientboundInvalidEtchUrlPacket(""));
        }
        this.resultSlot.func_75215_d(ItemStack.field_190927_a);
        if (this.labelIndex.func_221495_b() >= 0 && this.labelIndex.func_221495_b() < EtchedMusicDiscItem.LabelPattern.values().length && this.url != null && EtchedMusicDiscItem.isValidURL(this.url)) {
            ItemStack discStack = this.discSlot.func_75211_c();
            ItemStack labelStack = this.labelSlot.func_75211_c();
            if (discStack.func_77973_b() == EtchedRegistry.ETCHED_MUSIC_DISC.get() || !discStack.func_190926_b() && !labelStack.func_190926_b()) {
                int currentId = this.urlId;
                ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    ItemStack resultStack = new ItemStack((IItemProvider)EtchedRegistry.ETCHED_MUSIC_DISC.get());
                    resultStack.func_190920_e(1);
                    int discColor = 0x515151;
                    int labelColor = 0xFFFFFF;
                    String author = this.player.func_145748_c_().getString();
                    String title = null;
                    if (discStack.func_77973_b() == EtchedRegistry.ETCHED_MUSIC_DISC.get()) {
                        discColor = EtchedMusicDiscItem.getPrimaryColor(discStack);
                        labelColor = EtchedMusicDiscItem.getSecondaryColor(discStack);
                        author = EtchedMusicDiscItem.getMusic(discStack).map(EtchedMusicDiscItem.MusicInfo::getAuthor).orElse(null);
                        title = EtchedMusicDiscItem.getMusic(discStack).map(EtchedMusicDiscItem.MusicInfo::getTitle).orElse(null);
                    }
                    if (!labelStack.func_190926_b() && labelStack.func_82837_s()) {
                        title = labelStack.func_200301_q().getString();
                    }
                    if (SoundCloud.isValidUrl(this.url)) {
                        if (this.cachedAuthor == null || this.cachedTitle == null) {
                            try {
                                Pair<String, String> track = SoundCloud.resolveTrack(this.url, null, Proxy.NO_PROXY);
                                this.cachedAuthor = (String)track.getFirst();
                                this.cachedTitle = (String)track.getSecond();
                            }
                            catch (Exception e) {
                                this.cachedAuthor = null;
                                this.cachedTitle = null;
                                if (!this.player.field_70170_p.func_201670_d()) {
                                    NetworkBridge.sendToPlayer((ServerPlayerEntity)this.player, new ClientboundInvalidEtchUrlPacket(e.getMessage()));
                                }
                                throw new CompletionException("Failed to connect to SoundCloud API", e);
                            }
                        }
                        author = this.cachedAuthor;
                        title = this.cachedTitle;
                    } else if (!EtchedMusicDiscItem.isLocalSound(this.url)) {
                        try {
                            EtchingMenu.checkStatus(this.url);
                        }
                        catch (UnknownHostException e) {
                            if (!this.player.field_70170_p.func_201670_d()) {
                                NetworkBridge.sendToPlayer((ServerPlayerEntity)this.player, new ClientboundInvalidEtchUrlPacket("Unknown host: " + this.url));
                            }
                            throw new CompletionException("Invalid URL", e);
                        }
                        catch (Exception e) {
                            if (!this.player.field_70170_p.func_201670_d()) {
                                NetworkBridge.sendToPlayer((ServerPlayerEntity)this.player, new ClientboundInvalidEtchUrlPacket(e.getLocalizedMessage()));
                            }
                            throw new CompletionException("Invalid URL", e);
                        }
                    }
                    if (discStack.func_77973_b() instanceof BlankMusicDiscItem) {
                        discColor = ((BlankMusicDiscItem)discStack.func_77973_b()).func_200886_f(discStack);
                    }
                    if (labelStack.func_77973_b() instanceof MusicLabelItem) {
                        labelColor = ((MusicLabelItem)labelStack.func_77973_b()).func_200886_f(labelStack);
                    }
                    EtchedMusicDiscItem.MusicInfo info = new EtchedMusicDiscItem.MusicInfo();
                    info.setAuthor(author != null ? author : this.player.func_145748_c_().getString());
                    if (title != null) {
                        info.setTitle(title);
                    }
                    info.setUrl(EtchedMusicDiscItem.isLocalSound(this.url) ? new ResourceLocation(this.url).toString() : this.url);
                    EtchedMusicDiscItem.setMusic(resultStack, info);
                    EtchedMusicDiscItem.setColor(resultStack, discColor, labelColor);
                    EtchedMusicDiscItem.setPattern(resultStack, EtchedMusicDiscItem.LabelPattern.values()[this.labelIndex.func_221495_b()]);
                    return resultStack;
                }, (Executor)HTTPUtil.field_180193_a).thenAcceptAsync(resultStack -> {
                    if (this.urlId == currentId && !ItemStack.func_77989_b((ItemStack)resultStack, (ItemStack)this.resultSlot.func_75211_c()) && !ItemStack.func_77989_b((ItemStack)resultStack, (ItemStack)this.discSlot.func_75211_c())) {
                        this.resultSlot.func_75215_d(resultStack);
                    }
                })).exceptionally(e -> {
                    e.printStackTrace();
                    return null;
                });
            }
        }
    }

    public int getLabelIndex() {
        return this.labelIndex.func_221495_b();
    }

    public void setUrl(String string) {
        if (!Objects.equals(this.url, string)) {
            this.url = string;
            ++this.urlId;
            this.urlId %= 1000;
            this.cachedAuthor = null;
            this.cachedTitle = null;
            this.setupResultSlot();
        }
    }

    static {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.add((Object[])new String[]{"audio/wav", "audio/opus", "application/ogg", "audio/ogg", "audio/mpeg", "application/octet-stream"});
        VALID_FORMATS = builder.build();
    }
}

