/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.client.sound.format;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaveDataReader {
    private static final int RIFF_MAGIC = 1380533830;
    private static final int WAVE_MAGIC = 1463899717;
    private static final int FMT_MAGIC = 1718449184;
    private static final int DATA_MAGIC = 1684108385;
    private static final int WAVE_FORMAT_PCM = 1;
    private static final int WAVE_FORMAT_ALAW = 6;
    private static final int WAVE_FORMAT_MULAW = 7;

    public static AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat fileFormat = WaveDataReader.getFMT(stream);
        return new AudioInputStream(stream, fileFormat.getFormat(), fileFormat.getFrameLength());
    }

    private static AudioFileFormat getFMT(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFormat.Encoding encoding;
        int length;
        int nread = 0;
        DataInputStream dis = new DataInputStream(stream);
        int magic = dis.readInt();
        WaveDataReader.rllong(dis);
        int waveMagic = dis.readInt();
        if (magic != 1380533830 || waveMagic != 1463899717) {
            throw new UnsupportedAudioFileException("not a WAVE file");
        }
        try {
            while (true) {
                int fmt = dis.readInt();
                nread += 4;
                if (fmt != 1718449184) {
                    length = WaveDataReader.rllong(dis);
                    nread += 4;
                    if (length % 2 > 0) {
                        ++length;
                    }
                    nread += dis.skipBytes(length);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eof) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        length = WaveDataReader.rllong(dis);
        int endLength = (nread += 4) + length;
        short wav_type = WaveDataReader.rlshort(dis);
        nread += 2;
        if (wav_type == 1) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        } else if (wav_type == 6) {
            encoding = AudioFormat.Encoding.ALAW;
        } else if (wav_type == 7) {
            encoding = AudioFormat.Encoding.ULAW;
        } else {
            throw new UnsupportedAudioFileException("Not a supported WAV file");
        }
        short channels = WaveDataReader.rlshort(dis);
        nread += 2;
        if (channels <= 0) {
            throw new UnsupportedAudioFileException("Invalid number of channels");
        }
        long sampleRate = WaveDataReader.rllong(dis);
        nread += 4;
        WaveDataReader.rllong(dis);
        nread += 4;
        WaveDataReader.rlshort(dis);
        nread += 2;
        short sampleSizeInBits = WaveDataReader.rlshort(dis);
        nread += 2;
        if (sampleSizeInBits <= 0) {
            throw new UnsupportedAudioFileException("Invalid bitsPerSample");
        }
        if (sampleSizeInBits == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (endLength > nread) {
            dis.skipBytes(endLength - nread);
        }
        nread = 0;
        try {
            while (true) {
                int datahdr = dis.readInt();
                nread += 4;
                if (datahdr != 1684108385) {
                    int thisLength = WaveDataReader.rllong(dis);
                    nread += 4;
                    if (thisLength % 2 > 0) {
                        ++thisLength;
                    }
                    nread += dis.skipBytes(thisLength);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eof) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        int dataLength = WaveDataReader.rllong(dis);
        AudioFormat format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, (sampleSizeInBits + 7) / 8 * channels, sampleRate, false);
        return new AudioFileFormat(AudioFileFormat.Type.WAVE, format, dataLength / format.getFrameSize());
    }

    private static int rllong(DataInputStream dis) throws IOException {
        int i = dis.readInt();
        int b1 = (i & 0xFF) << 24;
        int b2 = (i & 0xFF00) << 8;
        int b3 = (i & 0xFF0000) >> 8;
        int b4 = (i & 0xFF000000) >>> 24;
        i = b1 | b2 | b3 | b4;
        return i;
    }

    private static short rlshort(DataInputStream dis) throws IOException {
        short s = dis.readShort();
        short high = (short)((s & 0xFF) << 8);
        short low = (short)((s & 0xFF00) >>> 8);
        s = (short)(high | low);
        return s;
    }
}

