/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import me.jaackson.etched.EtchedRegistry;
import me.jaackson.etched.bridge.NetworkBridge;
import me.jaackson.etched.common.item.EtchedMusicDiscItem;
import me.jaackson.etched.common.item.MusicLabelItem;
import me.jaackson.etched.common.menu.EtchingMenu;
import me.jaackson.etched.common.network.ServerboundSetEtchingUrlPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class EtchingScreen
extends ContainerScreen<EtchingMenu>
implements IContainerListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("etched", "textures/gui/container/etching_table.png");
    private ItemStack discStack;
    private ItemStack labelStack;
    private TextFieldWidget url;
    private int urlTicks;
    private String oldUrl;
    private String invalidReason;
    private boolean displayLabels;

    public EtchingScreen(EtchingMenu menu, PlayerInventory inventory, ITextComponent component) {
        super((Container)menu, inventory, component);
        this.field_147000_g = 180;
        this.field_238745_s_ += 14;
        this.discStack = ItemStack.field_190927_a;
        this.labelStack = ItemStack.field_190927_a;
        this.invalidReason = "";
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.url = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 11, this.field_147009_r + 25, 154, 16, (ITextComponent)new TranslationTextComponent("container.etched.etching_table"));
        this.url.func_146193_g(-1);
        this.url.func_146204_h(-1);
        this.url.func_146185_a(false);
        this.url.func_146203_f(32500);
        this.url.func_212954_a(s -> {
            if (!Objects.equals(this.oldUrl, s) && this.urlTicks <= 0) {
                NetworkBridge.sendToServer(new ServerboundSetEtchingUrlPacket(""));
            }
            this.urlTicks = 8;
        });
        this.url.func_146205_d(true);
        this.field_230705_e_.add(this.url);
        ((EtchingMenu)this.field_147002_h).func_75132_a(this);
    }

    public void func_231152_a_(Minecraft minecraft, int i, int j) {
        String string = this.url.func_146179_b();
        this.func_231158_b_(minecraft, i, j);
        this.url.func_146180_a(string);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.url.func_146178_a();
        if (this.urlTicks > 0) {
            --this.urlTicks;
            if (this.urlTicks <= 0 && !Objects.equals(this.oldUrl, this.url.func_146179_b())) {
                this.oldUrl = this.url.func_146179_b();
                NetworkBridge.sendToServer(new ServerboundSetEtchingUrlPacket(this.url.func_146179_b()));
            }
        }
    }

    public void func_71110_a(Container abstractContainerMenu, NonNullList<ItemStack> nonNullList) {
        this.func_71111_a(abstractContainerMenu, 0, abstractContainerMenu.func_75139_a(0).func_75211_c());
        this.func_71111_a(abstractContainerMenu, 1, abstractContainerMenu.func_75139_a(1).func_75211_c());
    }

    public void func_71111_a(Container abstractContainerMenu, int slot, ItemStack stack) {
        if (slot == 0) {
            if (this.discStack.func_190926_b() && !stack.func_190926_b()) {
                this.url.func_146180_a("");
            }
            EtchedMusicDiscItem.getMusic(stack).ifPresent(musicInfo -> this.url.func_146180_a(musicInfo.getUrl()));
            this.discStack = stack;
        }
        if (slot == 1) {
            this.labelStack = stack;
        }
        boolean editable = this.discStack.func_77973_b() == EtchedRegistry.ETCHED_MUSIC_DISC.get() || !this.discStack.func_190926_b() && !this.labelStack.func_190926_b();
        this.url.func_146184_c(editable);
        this.url.func_146189_e(editable);
        this.url.func_146195_b(editable);
        this.func_231035_a_((IGuiEventListener)(editable ? this.url : null));
        this.displayLabels = !this.discStack.func_190926_b() && !this.labelStack.func_190926_b();
    }

    public void func_71112_a(Container abstractContainerMenu, int index, int value) {
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        this.url.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(poseStack, mouseX, mouseY);
    }

    protected void func_230459_a_(MatrixStack poseStack, int mouseX, int mouseY) {
        super.func_230459_a_(poseStack, mouseX, mouseY);
        boolean isEtched = this.discStack.func_77973_b() == EtchedRegistry.ETCHED_MUSIC_DISC.get();
        ArrayList<IReorderingProcessor> reasonLines = new ArrayList<IReorderingProcessor>();
        if (!isEtched && !this.discStack.func_190926_b() && this.labelStack.func_190926_b()) {
            reasonLines.add(new TranslationTextComponent("screen.etched.etching_table.error.missing_label").func_241878_f());
        } else if (!isEtched && this.discStack.func_190926_b() && !this.labelStack.func_190926_b()) {
            reasonLines.add(new TranslationTextComponent("screen.etched.etching_table.error.missing_disc").func_241878_f());
        } else if (!this.url.func_146179_b().isEmpty() && !EtchedMusicDiscItem.isValidURL(this.url.func_146179_b()) || !this.invalidReason.isEmpty()) {
            reasonLines.add(new TranslationTextComponent("screen.etched.etching_table.error.invalid_url").func_241878_f());
            if (!this.invalidReason.isEmpty()) {
                reasonLines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)new StringTextComponent(this.invalidReason).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}), 200));
            }
        }
        if (mouseX >= this.field_147003_i + 83 && mouseX < this.field_147003_i + 110 && mouseY >= this.field_147009_r + 44 && mouseY < this.field_147009_r + 61) {
            this.func_238654_b_(poseStack, reasonLines, mouseX, mouseY);
        }
    }

    protected void func_230450_a_(MatrixStack poseStack, float f, int mouseX, int mouseY) {
        this.func_230446_a_(poseStack);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(poseStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (!this.url.func_146179_b().isEmpty() && !EtchedMusicDiscItem.isValidURL(this.url.func_146179_b()) || !this.invalidReason.isEmpty() || this.discStack.func_77973_b() != EtchedRegistry.ETCHED_MUSIC_DISC.get() && (!this.discStack.func_190926_b() && this.labelStack.func_190926_b() || this.discStack.func_190926_b() && !this.labelStack.func_190926_b())) {
            this.func_238474_b_(poseStack, this.field_147003_i + 83, this.field_147009_r + 44, 0, 226, 27, 17);
        }
        this.func_238474_b_(poseStack, this.field_147003_i + 9, this.field_147009_r + 21, 0, this.discStack.func_77973_b() == EtchedRegistry.ETCHED_MUSIC_DISC.get() || !this.discStack.func_190926_b() && !this.labelStack.func_190926_b() ? 180 : 196, 158, 16);
        if (this.displayLabels) {
            for (int index = 0; index < 6; ++index) {
                int x = this.field_147003_i + 46 + index * 14;
                int y = this.field_147009_r + 65;
                this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
                int u = index == ((EtchingMenu)this.field_147002_h).getLabelIndex() ? 14 : (mouseX >= x && mouseY >= y && mouseX < x + 14 && mouseY < y + 14 ? 28 : 0);
                this.func_238474_b_(poseStack, x, y, u, 212, 14, 14);
                this.renderLabel(poseStack, x, y, index);
            }
        }
    }

    private void renderLabel(MatrixStack poseStack, int x, int y, int index) {
        int labelColor;
        if (this.labelStack.func_190926_b() || this.discStack.func_190926_b()) {
            return;
        }
        EtchedMusicDiscItem.LabelPattern pattern = EtchedMusicDiscItem.LabelPattern.values()[index];
        int n = labelColor = this.labelStack.func_77973_b() instanceof MusicLabelItem ? ((MusicLabelItem)this.labelStack.func_77973_b()).func_200886_f(this.labelStack) : 0xFFFFFF;
        if (pattern.isColorable()) {
            RenderSystem.color3f((float)((float)(labelColor >> 16 & 0xFF) / 255.0f), (float)((float)(labelColor >> 8 & 0xFF) / 255.0f), (float)((float)(labelColor & 0xFF) / 255.0f));
        }
        RenderSystem.alphaFunc((int)514, (float)1.0f);
        RenderSystem.enableAlphaTest();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pattern.getTexture());
        IngameGui.func_238463_a_((MatrixStack)poseStack, (int)x, (int)y, (float)1.0f, (float)1.0f, (int)14, (int)14, (int)16, (int)16);
        RenderSystem.disableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int i) {
        if (this.displayLabels) {
            for (int index = 0; index < 6; ++index) {
                int x = this.field_147003_i + 46 + index * 14;
                int y = this.field_147009_r + 65;
                if (!(mouseX >= (double)x) || !(mouseY >= (double)y) || !(mouseX < (double)(x + 14)) || !(mouseY < (double)(y + 14)) || ((EtchingMenu)this.field_147002_h).getLabelIndex() == index) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.field_230706_i_.field_71442_b.func_78756_a(((EtchingMenu)this.field_147002_h).field_75152_c, index);
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, i);
    }

    public boolean func_231046_a_(int i, int j, int k) {
        return this.url.func_231046_a_(i, j, k) || this.url.func_230999_j_() && this.url.func_146176_q() && i != 256 || super.func_231046_a_(i, j, k);
    }

    public void setReason(String exception) {
        this.invalidReason = exception;
    }
}

