/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.bridge.forge;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import me.jaackson.etched.bridge.RegistryBridge;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class RegistryBridgeImpl {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"etched");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"etched");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"etched");
    public static final DeferredRegister<TileEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"etched");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"etched");
    public static final DeferredRegister<ContainerType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"etched");
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"etched");
    public static final DeferredRegister<PointOfInterestType> POINT_OF_INTEREST_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"etched");

    public static <T extends SoundEvent> Supplier<T> registerSound(String name, Supplier<T> object) {
        return SOUND_EVENTS.register(name, object);
    }

    public static <T extends Item> Supplier<T> registerItem(String name, Supplier<T> object) {
        return ITEMS.register(name, object);
    }

    public static <T extends Block> Supplier<T> registerBlock(String name, Supplier<T> object) {
        return BLOCKS.register(name, object);
    }

    public static <B extends TileEntity, T extends TileEntityType.Builder<B>> Supplier<TileEntityType<B>> registerBlockEntity(String name, Supplier<T> object) {
        return BLOCK_ENTITIES.register(name, () -> ((TileEntityType.Builder)object.get()).func_206865_a(null));
    }

    public static <E extends Entity, T extends EntityType.Builder<E>> Supplier<EntityType<E>> registerEntity(String name, Supplier<T> object) {
        return ENTITIES.register(name, () -> ((EntityType.Builder)object.get()).func_206830_a("etched:" + name));
    }

    public static <T extends Container> Supplier<ContainerType<T>> registerMenu(String name, RegistryBridge.MenuFactory<T> object) {
        return MENU_TYPES.register(name, () -> new ContainerType(object::create));
    }

    public static Supplier<VillagerProfession> registerProfession(String name, Supplier<PointOfInterestType> poiType, @Nullable Supplier<SoundEvent> workSound) {
        return VILLAGER_PROFESSIONS.register(name, () -> new VillagerProfession("etched:" + name, (PointOfInterestType)poiType.get(), ImmutableSet.of(), ImmutableSet.of(), workSound != null ? (SoundEvent)workSound.get() : null));
    }

    public static Supplier<PointOfInterestType> registerPOI(String name, Supplier<Block> block, int maxTickets, int validRange) {
        return POINT_OF_INTEREST_TYPES.register(name, () -> new PointOfInterestType("etched:" + name, PointOfInterestType.func_221042_a((Block)((Block)block.get())), maxTickets, validRange));
    }

    public static void registerVillagerTrades(Supplier<VillagerProfession> prof, Supplier<Int2ObjectMap<VillagerTrades.ITrade[]>> listings) {
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.getType() == prof.get()) {
                ((Int2ObjectMap)listings.get()).forEach((tier, listing) -> e.getTrades().put(tier.intValue(), Arrays.asList(listing)));
            }
        });
    }

    @SafeVarargs
    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemColor(IItemColor color, Supplier<Item> ... items) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> {
            for (Supplier item : items) {
                e.getItemColors().func_199877_a(color, new IItemProvider[]{(IItemProvider)item.get()});
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemOverride(Item item, ResourceLocation resourceLocation, IItemPropertyGetter itemPropertyFunction) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)resourceLocation, (IItemPropertyGetter)itemPropertyFunction);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerBlockRenderType(Block block, RenderType type) {
        RenderTypeLookup.setRenderLayer((Block)block, (RenderType)type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static synchronized <T extends Entity> void registerEntityRenderer(EntityType<T> entityType, Function<EntityRendererManager, EntityRenderer<T>> factory) {
        EntityRendererManager dispatcher = Minecraft.func_71410_x().func_175598_ae();
        dispatcher.func_229087_a_(entityType, factory.apply(dispatcher));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerSprite(ResourceLocation sprite, ResourceLocation atlas) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> {
            AtlasTexture texture = e.getMap();
            if (atlas.equals((Object)texture.func_229223_g_())) {
                e.addSprite(sprite);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <M extends Container, S extends Screen> void registerScreenFactory(ContainerType<M> type, RegistryBridge.ScreenFactory<M, S> object) {
        ScreenManager.func_216911_a(type, object::create);
    }
}

