/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.bridge.forge;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.jaackson.etched.common.network.EtchedPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkBridgeImpl {
    public static final SimpleChannel PLAY = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("etched", "play")).networkProtocolVersion(() -> "1").clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).simpleChannel();
    private static int currentIndex = -1;

    public static <T extends EtchedPacket> void registerPlayToClient(ResourceLocation channel, Class<T> messageType, Function<PacketBuffer, T> read, Supplier<Consumer<T>> handle) {
        PLAY.registerMessage(currentIndex++, messageType, EtchedPacket::write, read, (packet, context) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)context.get();
            if (ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ctx.enqueueWork(() -> NetworkBridgeImpl.lambda$registerPlayToClient$1((Supplier)handle, packet));
                ctx.setPacketHandled(true);
            }
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static <T extends EtchedPacket> void registerPlayToServer(ResourceLocation channel, Class<T> messageType, Function<PacketBuffer, T> read, BiConsumer<T, PlayerEntity> handle) {
        PLAY.registerMessage(currentIndex++, messageType, EtchedPacket::write, read, (packet, context) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)context.get();
            if (ctx.getDirection().getReceptionSide() == LogicalSide.SERVER) {
                ctx.enqueueWork(() -> {
                    if (ctx.getSender() == null) {
                        return;
                    }
                    handle.accept((Object)packet, (PlayerEntity)ctx.getSender());
                });
                ctx.setPacketHandled(true);
            }
        }, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static void sendToPlayer(ServerPlayerEntity player, EtchedPacket packet) {
        PLAY.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendToTracking(Entity tracking, EtchedPacket packet) {
        PLAY.send(PacketDistributor.TRACKING_ENTITY.with(() -> tracking), (Object)packet);
    }

    public static void sendToNear(ServerWorld level, double x, double y, double z, double distance, EtchedPacket packet) {
        PLAY.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, distance * distance, level.func_234923_W_())), (Object)packet);
    }

    public static void sendToServer(EtchedPacket packet) {
        PLAY.sendToServer((Object)packet);
    }

    public static IPacket<?> toVanillaPacket(EtchedPacket packet, boolean clientbound) {
        return PLAY.toVanillaPacket((Object)packet, clientbound ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER);
    }

    private static /* synthetic */ void lambda$registerPlayToClient$1(Supplier handle, EtchedPacket packet) {
        ((Consumer)handle.get()).accept(packet);
    }
}

