/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookCategory;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.common.book.Book;

public abstract class GuiBookEntryList
extends GuiBook {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    BookTextRenderer text;
    List<Button> dependentButtons;
    List<BookEntry> allEntries;
    List<BookEntry> visibleEntries;
    TextFieldWidget searchField;

    public GuiBookEntryList(Book book, ITextComponent title) {
        super(book, title);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.text = new BookTextRenderer(this, this.getDescriptionText(), 15, 40);
        this.visibleEntries = new ArrayList<BookEntry>();
        this.allEntries = new ArrayList<BookEntry>(this.getEntries());
        this.allEntries.removeIf(BookEntry::shouldHide);
        if (this.shouldSortEntryList()) {
            Collections.sort(this.allEntries);
        }
        this.searchField = this.createSearchBar();
        this.dependentButtons = new ArrayList<Button>();
        this.buildEntryButtons();
    }

    protected TextFieldWidget createSearchBar() {
        TextFieldWidget field = new TextFieldWidget(this.field_230712_o_, 160, 170, 90, 12, StringTextComponent.field_240750_d_);
        field.func_146203_f(32);
        field.func_146185_a(false);
        field.func_146205_d(false);
        field.func_146195_b(true);
        return field;
    }

    protected abstract String getDescriptionText();

    protected abstract Collection<BookEntry> getEntries();

    protected boolean doesEntryCountForProgress(BookEntry entry) {
        return true;
    }

    protected boolean shouldDrawProgressBar() {
        return true;
    }

    protected boolean shouldSortEntryList() {
        return true;
    }

    protected void addSubcategoryButtons() {
    }

    @Override
    void drawForegroundElements(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.drawForegroundElements(ms, mouseX, mouseY, partialTicks);
        if (this.spread == 0) {
            this.drawCenteredStringNoShadow(ms, this.func_231171_q_().func_241878_f(), 73, 18, this.book.headerColor);
            this.drawCenteredStringNoShadow(ms, this.getChapterListTitle(), 199, 18, this.book.headerColor);
            GuiBookEntryList.drawSeparator(ms, this.book, 15, 30);
            GuiBookEntryList.drawSeparator(ms, this.book, 141, 30);
            this.text.render(ms, mouseX, mouseY);
            if (this.shouldDrawProgressBar()) {
                this.drawProgressBar(ms, this.book, mouseX, mouseY, this::doesEntryCountForProgress);
            }
        } else if (this.spread % 2 == 1 && this.spread == this.maxSpreads - 1 && this.dependentButtons.size() <= 13) {
            GuiBookEntryList.drawPageFiller(ms, this.book);
        }
        if (!this.searchField.func_146179_b().isEmpty()) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBookEntryList.drawFromTexture(ms, this.book, this.searchField.field_230690_l_ - 8, this.searchField.field_230691_m_, 140, 183, 99, 14);
            IFormattableTextComponent toDraw = new StringTextComponent(this.searchField.func_146179_b()).func_230530_a_(this.book.getFontStyle());
            this.field_230712_o_.func_238422_b_(ms, toDraw.func_241878_f(), (float)(this.searchField.field_230690_l_ + 7), (float)(this.searchField.field_230691_m_ + 1), 0);
        }
        if (this.visibleEntries.isEmpty()) {
            if (!this.searchField.func_146179_b().isEmpty()) {
                this.drawCenteredStringNoShadow(ms, I18n.func_135052_a((String)"patchouli.gui.lexicon.no_results", (Object[])new Object[0]), 199, 80, 0x333333);
                ms.func_227862_a_(2.0f, 2.0f, 2.0f);
                this.drawCenteredStringNoShadow(ms, I18n.func_135052_a((String)"patchouli.gui.lexicon.sad", (Object[])new Object[0]), 99, 47, 0x999999);
                ms.func_227862_a_(0.5f, 0.5f, 0.5f);
            } else {
                this.drawCenteredStringNoShadow(ms, this.getNoEntryMessage(), 199, 80, 0x333333);
            }
        }
    }

    protected String getChapterListTitle() {
        return I18n.func_135052_a((String)"patchouli.gui.lexicon.chapters", (Object[])new Object[0]);
    }

    protected String getNoEntryMessage() {
        return I18n.func_135052_a((String)"patchouli.gui.lexicon.no_entries", (Object[])new Object[0]);
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.text.click(mouseX, mouseY, mouseButton) || this.searchField.func_231044_a_(mouseX - (double)this.bookLeft, mouseY - (double)this.bookTop, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    public boolean func_231042_a_(char c, int i) {
        String currQuery = this.searchField.func_146179_b();
        if (this.searchField.func_231042_a_(c, i)) {
            if (!this.searchField.func_146179_b().equals(currQuery)) {
                this.buildEntryButtons();
            }
            return true;
        }
        return super.func_231042_a_(c, i);
    }

    @Override
    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        String currQuery = this.searchField.func_146179_b();
        if (key == 257) {
            if (this.visibleEntries.size() == 1) {
                this.displayLexiconGui(new GuiBookEntry(this.book, this.visibleEntries.get(0)), true);
                return true;
            }
        } else if (this.searchField.func_231046_a_(key, scanCode, modifiers)) {
            if (!this.searchField.func_146179_b().equals(currQuery)) {
                this.buildEntryButtons();
            }
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    public void handleButtonCategory(Button button) {
        this.displayLexiconGui(new GuiBookCategory(this.book, ((GuiButtonCategory)button).getCategory()), true);
    }

    public void handleButtonEntry(Button button) {
        GuiBookEntry.displayOrBookmark(this, ((GuiButtonEntry)button).getEntry());
    }

    @Override
    void onPageChanged() {
        this.buildEntryButtons();
    }

    void buildEntryButtons() {
        this.removeButtonsIn(this.dependentButtons);
        this.dependentButtons.clear();
        this.visibleEntries.clear();
        String query = this.searchField.func_146179_b().toLowerCase();
        this.allEntries.stream().filter(e -> e.isFoundByQuery(query)).forEach(this.visibleEntries::add);
        this.maxSpreads = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxSpreads += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.spread;
        }
        if (this.spread == 0) {
            this.addEntryButtons(141, 38, 0, 11);
            this.addSubcategoryButtons();
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(15, 18, start, 13);
            this.addEntryButtons(141, 18, start + 13, 13);
        }
    }

    int getEntryCountStart() {
        if (this.spread == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.spread - 1);
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            GuiButtonEntry button = new GuiButtonEntry(this, this.bookLeft + x, this.bookTop + y + i * 11, this.visibleEntries.get(start + i), this::handleButtonEntry);
            this.func_230480_a_(button);
            this.dependentButtons.add(button);
        }
    }

    public String getSearchQuery() {
        return this.searchField.func_146179_b();
    }
}

