/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.config.CommonConfig;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MonsterEntity.class})
public class MonsterEntityMixin {
    @Inject(method={"canMonsterSpawnInLight"}, at={@At(value="RETURN")}, cancellable=true)
    private static void endermenCheck(EntityType<? extends MonsterEntity> type, IServerWorld world, SpawnReason spawnReason, BlockPos pos, Random random, CallbackInfoReturnable<Boolean> info) {
        boolean canSpawn = (Boolean)info.getReturnValue();
        if (CommonConfig.reduceEndermanSpawn() && canSpawn && spawnReason == SpawnReason.NATURAL && type == EntityType.field_200803_q) {
            AxisAlignedBB box = new AxisAlignedBB(pos).func_186662_g(16.0);
            List entities = world.func_175647_a(EndermanEntity.class, box, entity -> true);
            info.setReturnValue((Object)(entities.size() < 6 ? 1 : 0));
        }
    }
}

