/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.world.feature.InvertedScatterFeature;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;

public class VineFeature
extends InvertedScatterFeature {
    private final Block vineBlock;
    private final int maxLength;

    public VineFeature(Block vineBlock, int maxLength) {
        super(6);
        this.vineBlock = vineBlock;
        this.maxLength = maxLength;
    }

    @Override
    public boolean canGenerate(ISeedReader world, Random random, BlockPos center, BlockPos blockPos, float radius) {
        return world.func_175623_d(blockPos) && this.vineBlock.func_196260_a(Blocks.field_150350_a.func_176223_P(), (IWorldReader)world, blockPos) && !world.func_180495_p(blockPos.func_177984_a()).func_203425_a(this.vineBlock);
    }

    @Override
    public void generate(ISeedReader world, Random random, BlockPos blockPos) {
        int h = BlockHelper.downRay((IWorldReader)world, blockPos, random.nextInt(this.maxLength)) - 1;
        if (h > 2) {
            BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos, (BlockState)this.vineBlock.func_176223_P().func_206870_a(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)));
            for (int i = 1; i < h; ++i) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos.func_177979_c(i), (BlockState)this.vineBlock.func_176223_P().func_206870_a(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE)));
            }
            BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos.func_177979_c(h), (BlockState)this.vineBlock.func_176223_P().func_206870_a(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
        }
    }
}

