/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.SulphurCrystalBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SulphuricCaveFeature
extends Feature<NoFeatureConfig> {
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final Direction[] HORIZONTAL = BlockHelper.makeHorizontal();

    public SulphuricCaveFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int radius = ModMathHelper.randRange(10, 30, rand);
        int top = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n(), pos.func_177952_p());
        BlockPos.Mutable bpos = new BlockPos.Mutable();
        bpos.func_223471_o(pos.func_177958_n());
        bpos.func_223472_q(pos.func_177952_p());
        bpos.func_185336_p(top - 1);
        BlockState state = world.func_180495_p((BlockPos)bpos);
        while (!state.func_235714_a_(ModTags.GEN_TERRAIN) && bpos.func_177956_o() > 5) {
            bpos.func_185336_p(bpos.func_177956_o() - 1);
            state = world.func_180495_p((BlockPos)bpos);
        }
        if (bpos.func_177956_o() < 10) {
            return false;
        }
        top = (int)((float)bpos.func_177956_o() - ((float)radius * 1.3f + 5.0f));
        while (state.func_235714_a_(ModTags.GEN_TERRAIN) || !state.func_204520_s().func_206888_e() && bpos.func_177956_o() > 5) {
            bpos.func_185336_p(bpos.func_177956_o() - 1);
            state = world.func_180495_p((BlockPos)bpos);
        }
        int bottom = (int)((float)bpos.func_177956_o() + (float)radius * 1.3f + 5.0f);
        if (top <= bottom) {
            return false;
        }
        BlockPos.Mutable mut = new BlockPos.Mutable();
        pos = new BlockPos(pos.func_177958_n(), ModMathHelper.randRange(bottom, top, rand), pos.func_177952_p());
        OpenSimplexNoise noise = new OpenSimplexNoise(ModMathHelper.getSeed(534, pos.func_177958_n(), pos.func_177952_p()));
        int x1 = pos.func_177958_n() - radius - 5;
        int z1 = pos.func_177952_p() - radius - 5;
        int x2 = pos.func_177958_n() + radius + 5;
        int z2 = pos.func_177952_p() + radius + 5;
        int y1 = ModMathHelper.floor((double)pos.func_177956_o() - (double)(radius + 5) / 1.6);
        int y2 = ModMathHelper.floor((double)pos.func_177956_o() + (double)(radius + 5) / 1.6);
        double hr = (double)radius * 0.75;
        double nr = (double)radius * 0.25;
        HashSet brimstone = Sets.newHashSet();
        BlockState rock = ((Block)ModBlocks.SULPHURIC_ROCK.stone.get()).func_176223_P();
        int waterLevel = pos.func_177956_o() + ModMathHelper.randRange(ModMathHelper.floor((double)radius * 0.8), radius, rand);
        for (int x = x1; x <= x2; ++x) {
            int xsq = x - pos.func_177958_n();
            xsq *= xsq;
            mut.func_223471_o(x);
            for (int z = z1; z <= z2; ++z) {
                int zsq = z - pos.func_177952_p();
                zsq *= zsq;
                mut.func_223472_q(z);
                for (int y = y1; y <= y2; ++y) {
                    int ysq = y - pos.func_177956_o();
                    ysq = (int)((double)ysq * 1.6);
                    ysq *= ysq;
                    mut.func_185336_p(y);
                    double r = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr;
                    double r2 = r + 5.0;
                    double dist = xsq + ysq + zsq;
                    if (dist < r * r) {
                        state = world.func_180495_p((BlockPos)mut);
                        if (!this.isReplaceable(state)) continue;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, y < waterLevel ? WATER : CAVE_AIR);
                        continue;
                    }
                    if (!(dist < r2 * r2) || !(state = world.func_180495_p((BlockPos)mut)).func_235714_a_(ModTags.GEN_TERRAIN) && !state.func_203425_a(Blocks.field_150350_a)) continue;
                    double v = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) + noise.eval((double)x * 0.03, (double)y * 0.03, (double)z * 0.03) * 0.5;
                    if (v > 0.4) {
                        brimstone.add(mut.func_185334_h());
                        continue;
                    }
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, rock);
                }
            }
        }
        brimstone.forEach(blockPos -> this.placeBrimstone(world, (BlockPos)blockPos, rand));
        if (rand.nextInt(4) == 0) {
            int count = ModMathHelper.randRange(5, 20, rand);
            for (int i = 0; i < count; ++i) {
                mut.func_189533_g((Vector3i)pos).func_196234_d(ModMathHelper.floor(rand.nextGaussian() * 2.0 + 0.5), 0, ModMathHelper.floor(rand.nextGaussian() * 2.0 + 0.5));
                int dist = ModMathHelper.floor(3.0f - ModMathHelper.length(mut.func_177958_n() - pos.func_177958_n(), mut.func_177952_p() - pos.func_177952_p())) + rand.nextInt(2);
                if (dist <= 0) continue;
                state = world.func_180495_p((BlockPos)mut);
                while (!state.func_204520_s().func_206888_e() || state.func_185904_a().equals(Material.field_203243_f)) {
                    mut.func_185336_p(mut.func_177956_o() - 1);
                    state = world.func_180495_p((BlockPos)mut);
                }
                if (!state.func_235714_a_(ModTags.GEN_TERRAIN) || world.func_180495_p(mut.func_177984_a()).func_203425_a((Block)ModBlocks.HYDROTHERMAL_VENT.get())) continue;
                for (int j = 0; j <= dist; ++j) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.SULPHURIC_ROCK.stone.get());
                    ModMathHelper.shuffle(HORIZONTAL, rand);
                    for (Direction dir : HORIZONTAL) {
                        BlockPos p = mut.func_177972_a(dir);
                        if (!rand.nextBoolean() || !world.func_180495_p(p).func_203425_a(Blocks.field_150355_j)) continue;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, p, (BlockState)((Block)ModBlocks.TUBE_WORM.get()).func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)dir));
                    }
                    mut.func_185336_p(mut.func_177956_o() + 1);
                }
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.HYDROTHERMAL_VENT.get());
                mut.func_185336_p(mut.func_177956_o() + 1);
                state = world.func_180495_p((BlockPos)mut);
                while (state.func_203425_a(Blocks.field_150355_j)) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, ((Block)ModBlocks.VENT_BUBBLE_COLUMN.get()).func_176223_P());
                    world.func_205220_G_().func_205360_a((BlockPos)mut, (Object)ModBlocks.VENT_BUBBLE_COLUMN.get(), ModMathHelper.randRange(8, 32, rand));
                    mut.func_185336_p(mut.func_177956_o() + 1);
                    state = world.func_180495_p((BlockPos)mut);
                }
            }
        }
        BlockHelper.fixBlocks((IWorld)world, new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2));
        return true;
    }

    private boolean isReplaceable(BlockState state) {
        return state.func_235714_a_(ModTags.GEN_TERRAIN) || state.func_203425_a((Block)ModBlocks.HYDROTHERMAL_VENT.get()) || state.func_203425_a((Block)ModBlocks.VENT_BUBBLE_COLUMN.get()) || state.func_203425_a((Block)ModBlocks.SULPHUR_CRYSTAL.get()) || state.func_185904_a().func_76222_j() || state.func_185904_a().equals(Material.field_151585_k) || state.func_185904_a().equals(Material.field_203243_f) || state.func_185904_a().equals(Material.field_151584_j);
    }

    private void placeBrimstone(ISeedReader world, BlockPos pos, Random random) {
        BlockState state = this.getBrimstone(world, pos);
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, state);
        if (((Boolean)state.func_177229_b((Property)BlockProperties.ACTIVATED)).booleanValue()) {
            this.makeShards(world, pos, random);
        }
    }

    private BlockState getBrimstone(ISeedReader world, BlockPos pos) {
        for (Direction dir : BlockHelper.DIRECTIONS) {
            if (!world.func_180495_p(pos.func_177972_a(dir)).func_203425_a(Blocks.field_150355_j)) continue;
            return (BlockState)((Block)ModBlocks.BRIMSTONE.get()).func_176223_P().func_206870_a((Property)BlockProperties.ACTIVATED, (Comparable)Boolean.valueOf(true));
        }
        return ((Block)ModBlocks.BRIMSTONE.get()).func_176223_P();
    }

    private void makeShards(ISeedReader world, BlockPos pos, Random random) {
        for (Direction dir : BlockHelper.DIRECTIONS) {
            BlockPos side;
            if (random.nextInt(16) != 0 || !world.func_180495_p(side = pos.func_177972_a(dir)).func_203425_a(Blocks.field_150355_j)) continue;
            BlockState state = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.SULPHUR_CRYSTAL.get()).func_176223_P().func_206870_a((Property)SulphurCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SulphurCrystalBlock.FACING, (Comparable)dir)).func_206870_a((Property)SulphurCrystalBlock.AGE, (Comparable)Integer.valueOf(random.nextInt(3)));
            BlockHelper.setWithoutUpdate((IWorldWriter)world, side, state);
        }
    }
}

