/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFCoordModify;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class OreLayerFeature
extends Feature<NoFeatureConfig> {
    private static final SDFSphere SPHERE = new SDFSphere();
    private static final SDFCoordModify NOISE = new SDFCoordModify();
    private static final SDF FUNCTION;
    private final BlockState state;
    private final float radius;
    private final int minY;
    private final int maxY;
    private OpenSimplexNoise noise;

    public OreLayerFeature(BlockState state, float radius, int minY, int maxY) {
        super(NoFeatureConfig.field_236558_a_);
        this.state = state;
        this.radius = radius;
        this.minY = minY;
        this.maxY = maxY;
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, NoFeatureConfig config) {
        float radius = this.radius * 0.5f;
        int r = ModMathHelper.floor(radius + 1.0f);
        int posX = ModMathHelper.randRange(Math.max(r - 16, 0), Math.min(31 - r, 15), random) + blockPos.func_177958_n();
        int posZ = ModMathHelper.randRange(Math.max(r - 16, 0), Math.min(31 - r, 15), random) + blockPos.func_177952_p();
        int posY = ModMathHelper.randRange(this.minY, this.maxY, random);
        if (this.noise == null) {
            this.noise = new OpenSimplexNoise(world.func_72905_C());
        }
        SPHERE.setRadius(radius).setBlock(this.state);
        NOISE.setFunction(vec -> {
            double x = (double)(vec.func_195899_a() + (float)blockPos.func_177958_n()) * 0.1;
            double z = (double)(vec.func_195902_c() + (float)blockPos.func_177952_p()) * 0.1;
            double offset = this.noise.eval(x, z);
            vec.func_195905_a(vec.func_195899_a(), vec.func_195900_b() + (float)offset * 8.0f, vec.func_195902_c());
        });
        FUNCTION.fillRecursive((IWorld)world, new BlockPos(posX, posY, posZ));
        return true;
    }

    static {
        SDF body = SPHERE;
        body = new SDFScale3D().setScale(1.0f, 0.2f, 1.0f).setSource(body);
        body = NOISE.setSource(body);
        body.setReplaceFunction(state -> state.func_203425_a(Blocks.field_150377_bs));
        FUNCTION = body;
    }
}

