/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.block.HelixTreeLeavesBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.SplineHelper;
import mod.beethoven92.betterendforge.common.util.sdf.PosInfo;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFRotation;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSmoothUnion;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnary;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnion;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class HelixTreeFeature
extends Feature<NoFeatureConfig> {
    private static final Function<PosInfo, BlockState> POST = info -> {
        if (ModBlocks.HELIX_TREE.isTreeLog(info.getStateUp()) && ModBlocks.HELIX_TREE.isTreeLog(info.getStateDown())) {
            return ((Block)ModBlocks.HELIX_TREE.log.get()).func_176223_P();
        }
        return info.getState();
    };

    public HelixTreeFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        float dz;
        float dx;
        if (!world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(ModTags.END_GROUND)) {
            return false;
        }
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, Blocks.field_150350_a.func_176223_P());
        float angle = rand.nextFloat() * ((float)Math.PI * 2);
        float radiusRange = ModMathHelper.randRange(4.5f, 6.0f, rand);
        float scale = ModMathHelper.randRange(0.5f, 1.0f, rand);
        ArrayList<Vector3f> spline = new ArrayList<Vector3f>(10);
        for (int i = 0; i < 10; ++i) {
            float radius = (0.9f - (float)i * 0.1f) * radiusRange;
            dx = (float)Math.sin((float)i + angle) * radius;
            dz = (float)Math.cos((float)i + angle) * radius;
            spline.add(new Vector3f(dx, (float)(i * 2), dz));
        }
        SDF sdf = SplineHelper.buildSDF(spline, 1.7f, 0.5f, p -> ((Block)ModBlocks.HELIX_TREE.bark.get()).func_176223_P());
        SDFUnary rotated = new SDFRotation().setRotation(Vector3f.field_229181_d_, (float)Math.PI).setSource(sdf);
        sdf = new SDFUnion().setSourceA(rotated).setSourceB(sdf);
        Vector3f lastPoint = (Vector3f)spline.get(spline.size() - 1);
        List<Vector3f> spline2 = SplineHelper.makeSpline(0.0f, 0.0f, 0.0f, 0.0f, 20.0f, 0.0f, 5);
        SDF stem = SplineHelper.buildSDF(spline2, 1.0f, 0.5f, p -> ((Block)ModBlocks.HELIX_TREE.bark.get()).func_176223_P());
        stem = new SDFTranslate().setTranslate(lastPoint.func_195899_a(), lastPoint.func_195900_b(), lastPoint.func_195902_c()).setSource(stem);
        sdf = new SDFSmoothUnion().setRadius(3.0f).setSourceA(sdf).setSourceB(stem);
        sdf = new SDFScale().setScale(scale).setSource(sdf);
        dx = 30.0f * scale;
        float dy1 = -20.0f * scale;
        float dy2 = 100.0f * scale;
        sdf.addPostProcess(POST).fillArea((IWorld)world, pos, new AxisAlignedBB(pos.func_177963_a((double)(-dx), (double)dy1, (double)(-dx)), pos.func_177963_a((double)dx, (double)dy2, (double)dx)));
        SplineHelper.scale(spline, scale);
        SplineHelper.fillSplineForce(spline, (IWorld)world, ((Block)ModBlocks.HELIX_TREE.bark.get()).func_176223_P(), pos, state -> state.func_185904_a().func_76222_j());
        SplineHelper.rotateSpline(spline, (float)Math.PI);
        SplineHelper.fillSplineForce(spline, (IWorld)world, ((Block)ModBlocks.HELIX_TREE.bark.get()).func_176223_P(), pos, state -> state.func_185904_a().func_76222_j());
        SplineHelper.scale(spline2, scale);
        BlockPos leafStart = pos.func_177963_a((double)lastPoint.func_195899_a() + 0.5, (double)lastPoint.func_195900_b() + 0.5, (double)lastPoint.func_195902_c() + 0.5);
        SplineHelper.fillSplineForce(spline2, (IWorld)world, ((Block)ModBlocks.HELIX_TREE.log.get()).func_176223_P(), leafStart, state -> state.func_185904_a().func_76222_j());
        spline.clear();
        float rad = ModMathHelper.randRange(8.0f, 11.0f, rand);
        int count = ModMathHelper.randRange(20, 30, rand);
        float scaleM = 20.0f / (float)count * scale * 1.75f;
        float hscale = 20.0f / (float)count * 0.05f;
        for (int i = 0; i <= count; ++i) {
            float radius = 1.0f - (float)i * hscale;
            radius = radius * radius * 2.0f - 1.0f;
            radius *= radius;
            radius = (1.0f - radius) * rad * scale;
            dx = (float)Math.sin((float)i * 0.45f + angle) * radius;
            dz = (float)Math.cos((float)i * 0.45f + angle) * radius;
            spline.add(new Vector3f(dx, (float)i * scaleM, dz));
        }
        Vector3f start = new Vector3f();
        Vector3f end = new Vector3f();
        lastPoint = (Vector3f)spline.get(0);
        BlockState leaf = ((Block)ModBlocks.HELIX_TREE_LEAVES.get()).func_176223_P();
        for (int i = 1; i < spline.size(); ++i) {
            Vector3f point = (Vector3f)spline.get(i);
            int minY = ModMathHelper.floor(lastPoint.func_195900_b());
            int maxY = ModMathHelper.floor(point.func_195900_b());
            float div = point.func_195900_b() - lastPoint.func_195900_b();
            for (float py = (float)minY; py <= (float)maxY; py += 0.2f) {
                start.func_195905_a(0.0f, py, 0.0f);
                float delta = (py - (float)minY) / div;
                float px = MathHelper.func_219799_g((float)delta, (float)lastPoint.func_195899_a(), (float)point.func_195899_a());
                float pz = MathHelper.func_219799_g((float)delta, (float)lastPoint.func_195902_c(), (float)point.func_195902_c());
                end.func_195905_a(px, py, pz);
                this.fillLine(start, end, world, leaf, leafStart, i / 2 - 1);
                float ax = Math.abs(px);
                float az = Math.abs(pz);
                if (ax > az) {
                    start.func_195905_a(start.func_195899_a(), start.func_195900_b(), start.func_195902_c() + az > 0.0f ? 1.0f : -1.0f);
                    end.func_195905_a(end.func_195899_a(), end.func_195900_b(), end.func_195902_c() + az > 0.0f ? 1.0f : -1.0f);
                } else {
                    start.func_195905_a(start.func_195899_a() + ax > 0.0f ? 1.0f : -1.0f, start.func_195900_b(), start.func_195902_c());
                    end.func_195905_a(end.func_195899_a() + ax > 0.0f ? 1.0f : -1.0f, end.func_195900_b(), end.func_195902_c());
                }
                this.fillLine(start, end, world, leaf, leafStart, i / 2 - 1);
            }
            lastPoint = point;
        }
        leaf = (BlockState)leaf.func_206870_a((Property)HelixTreeLeavesBlock.COLOR, (Comparable)Integer.valueOf(7));
        if (world.func_180495_p(leafStart = leafStart.func_177963_a(0.0, (double)lastPoint.func_195900_b(), 0.0)).func_196958_f()) {
            BlockHelper.setWithoutUpdate((IWorldWriter)world, leafStart, leaf);
            leafStart = leafStart.func_177984_a();
            if (world.func_180495_p(leafStart).func_196958_f()) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, leafStart, leaf);
                leafStart = leafStart.func_177984_a();
                if (world.func_180495_p(leafStart).func_196958_f()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, leafStart, leaf);
                }
            }
        }
        return true;
    }

    private void fillLine(Vector3f start, Vector3f end, ISeedReader world, BlockState state, BlockPos pos, int offset) {
        float dx = end.func_195899_a() - start.func_195899_a();
        float dy = end.func_195900_b() - start.func_195900_b();
        float dz = end.func_195902_c() - start.func_195902_c();
        float max = ModMathHelper.max(Math.abs(dx), Math.abs(dy), Math.abs(dz));
        int count = ModMathHelper.floor(max + 1.0f);
        dx /= max;
        dy /= max;
        dz /= max;
        float x = start.func_195899_a();
        float y = start.func_195900_b();
        float z = start.func_195902_c();
        BlockPos.Mutable bPos = new BlockPos.Mutable();
        for (int i = 0; i < count; ++i) {
            bPos.func_189532_c((double)(x + (float)pos.func_177958_n()), (double)(y + (float)pos.func_177956_o()), (double)(z + (float)pos.func_177952_p()));
            int color = ModMathHelper.floor((float)i / (float)count * 7.0f + 0.5f) + offset;
            color = MathHelper.func_76125_a((int)color, (int)0, (int)7);
            if (world.func_180495_p((BlockPos)bPos).func_185904_a().func_76222_j()) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bPos, (BlockState)state.func_206870_a((Property)HelixTreeLeavesBlock.COLOR, (Comparable)Integer.valueOf(color)));
            }
            x += dx;
            y += dy;
            z += dz;
        }
        bPos.func_189532_c((double)(end.func_195899_a() + (float)pos.func_177958_n()), (double)(end.func_195900_b() + (float)pos.func_177956_o()), (double)(end.func_195902_c() + (float)pos.func_177952_p()));
        if (world.func_180495_p((BlockPos)bPos).func_185904_a().func_76222_j()) {
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bPos, (BlockState)state.func_206870_a((Property)HelixTreeLeavesBlock.COLOR, (Comparable)Integer.valueOf(7)));
        }
    }
}

