/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModFeatures;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.feature.SpireFeature;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FloatingSpireFeature
extends SpireFeature {
    @Override
    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        float rMin;
        int i;
        int minY = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n(), pos.func_177952_p());
        int y = minY > 57 ? ModMathHelper.floor((float)ModMathHelper.randRange(minY, minY * 2, rand) * 0.5f + 32.0f) : ModMathHelper.randRange(64, 192, rand);
        pos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        SDF sdf = new SDFSphere().setRadius(ModMathHelper.randRange(2, 3, rand)).setBlock(Blocks.field_150377_bs);
        int count = ModMathHelper.randRange(3, 5, rand);
        for (i = 0; i < count; ++i) {
            rMin = (float)i * 1.3f + 2.5f;
            sdf = this.addSegment(sdf, ModMathHelper.randRange(rMin, rMin + 1.5f, rand), rand);
        }
        for (i = count - 1; i > 0; --i) {
            rMin = (float)i * 1.3f + 2.5f;
            sdf = this.addSegment(sdf, ModMathHelper.randRange(rMin, rMin + 1.5f, rand), rand);
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(rand.nextLong());
        sdf = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)(Math.abs(noise.eval((double)vec.func_195899_a() * 0.1, (double)vec.func_195900_b() * 0.1, (double)vec.func_195902_c() * 0.1)) * 3.0 + Math.abs(noise.eval((double)vec.func_195899_a() * 0.3, (double)vec.func_195900_b() * 0.3 + 100.0, (double)vec.func_195902_c() * 0.3)) * (double)1.3f))).setSource(sdf);
        BlockPos center = pos;
        ArrayList support = Lists.newArrayList();
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (info.getStateUp().func_196958_f()) {
                if (rand.nextInt(16) == 0) {
                    support.add(info.getPos().func_177984_a());
                }
                return world.func_226691_t_(info.getPos()).func_242440_e().func_242502_e().func_204108_a();
            }
            if (info.getState(Direction.UP, 3).func_196958_f()) {
                return world.func_226691_t_(info.getPos()).func_242440_e().func_242502_e().func_204109_b();
            }
            return info.getState();
        });
        sdf.fillRecursive((IWorld)world, center);
        support.forEach(bpos -> {
            if (ModBiomes.getFromBiome(world.func_226691_t_(bpos)) == ModBiomes.BLOSSOMING_SPIRES) {
                ModFeatures.TENANEA_BUSH.func_241855_a(world, generator, rand, bpos, null);
            }
        });
        return true;
    }
}

