/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.common.util.ColorHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorExtractor {
    private List<Center> centers = new ArrayList<Center>();
    private List<Integer> colors;
    private Integer result;

    public ColorExtractor(List<Integer> colors) {
        this.colors = colors;
        Random rnd = new Random();
        int size = colors.size();
        for (int i = 0; i < 4; ++i) {
            int color = colors.get(rnd.nextInt(size));
            this.centers.add(new Center(color));
        }
    }

    public int analize() {
        boolean moved = true;
        while (moved) {
            this.remap();
            moved = false;
            for (Center center2 : this.centers) {
                if (!center2.move()) continue;
                moved = true;
            }
        }
        ArrayList toClear = new ArrayList();
        this.centers.forEach(center -> {
            if (center.colors.isEmpty()) {
                toClear.add(center);
            }
        });
        if (toClear.size() > 0) {
            toClear.forEach(clear -> this.centers.remove(clear));
        }
        this.centers.sort(Center.COMPARATOR);
        return this.getResult();
    }

    public int getResult() {
        if (this.result == null) {
            double weights = 0.0;
            double alpha = 0.0;
            double red = 0.0;
            double green = 0.0;
            double blue = 0.0;
            for (Center center : this.centers) {
                double weight = (double)center.colors.size() / (double)this.colors.size();
                weights += weight;
                alpha += center.a * weight;
                red += center.r * weight;
                green += center.g * weight;
                blue += center.b * weight;
            }
            int a = (int)Math.round(alpha / weights);
            int r = (int)Math.round(red / weights);
            int g = (int)Math.round(green / weights);
            int b = (int)Math.round(blue / weights);
            this.result = a << 24 | r << 16 | g << 8 | b;
        }
        return this.result;
    }

    private void remap() {
        this.centers.forEach(entry -> entry.colors.clear());
        this.colors.forEach(color -> {
            int id = 0;
            int base = this.centers.get(0).getColor();
            int dst = ColorHelper.colorDistance(color, base);
            for (Center center : this.centers) {
                base = center.getColor();
                int dst1 = ColorHelper.colorDistance(color, base);
                if (dst1 >= dst) continue;
                dst = dst1;
                id = this.centers.indexOf(center);
            }
            this.centers.get((int)id).colors.add((Integer)color);
        });
    }

    private static class Center {
        static final Comparator<Center> COMPARATOR = new Comparator<Center>(){

            @Override
            public int compare(Center c1, Center c2) {
                return Integer.compare(c1.getColor(), c2.getColor());
            }
        };
        List<Integer> colors = new ArrayList<Integer>();
        double a;
        double r;
        double g;
        double b;

        Center(int color) {
            this.a = color >> 24 & 0xFF;
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
        }

        private void update(double a, double r, double g, double b) {
            this.a = a;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public int getColor() {
            int a = (int)Math.round(this.a);
            int r = (int)Math.round(this.r);
            int g = (int)Math.round(this.g);
            int b = (int)Math.round(this.b);
            return a << 24 | r << 16 | g << 8 | b;
        }

        public boolean move() {
            double or = this.r;
            double og = this.g;
            double ob = this.b;
            double a = 0.0;
            double r = 0.0;
            double g = 0.0;
            double b = 0.0;
            int size = this.colors.size();
            for (int col : this.colors) {
                a += (double)(col >> 24 & 0xFF);
                r += (double)(col >> 16 & 0xFF);
                g += (double)(col >> 8 & 0xFF);
                b += (double)(col & 0xFF);
            }
            this.update(a /= (double)size, r /= (double)size, g /= (double)size, b /= (double)size);
            return Math.abs(r - or) > 0.1 || Math.abs(g - og) > 0.1 || Math.abs(b - ob) > 0.1;
        }
    }
}

