/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.rituals;

import com.google.common.collect.Sets;
import java.awt.Point;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.EndPortalBlock;
import mod.beethoven92.betterendforge.common.block.RunedFlavoliteBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModConfiguredFeatures;
import mod.beethoven92.betterendforge.common.teleporter.EndPortals;
import mod.beethoven92.betterendforge.common.tileentity.EternalPedestalTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.server.ServerWorld;

public class EternalRitual {
    private static final Set<Point> STRUCTURE_MAP = Sets.newHashSet((Object[])new Point[]{new Point(-4, -5), new Point(-4, 5), new Point(-6, 0), new Point(4, -5), new Point(4, 5), new Point(6, 0)});
    private static final Set<Point> FRAME_MAP = Sets.newHashSet((Object[])new Point[]{new Point(0, 0), new Point(0, 6), new Point(1, 0), new Point(1, 6), new Point(2, 1), new Point(2, 5), new Point(3, 2), new Point(3, 3), new Point(3, 4)});
    private static final Set<Point> PORTAL_MAP = Sets.newHashSet((Object[])new Point[]{new Point(0, 0), new Point(0, 1), new Point(0, 2), new Point(0, 3), new Point(0, 4), new Point(1, 0), new Point(1, 1), new Point(1, 2), new Point(1, 3), new Point(1, 4), new Point(2, 1), new Point(2, 2), new Point(2, 3)});
    private static final Set<Point> BASE_MAP = Sets.newHashSet((Object[])new Point[]{new Point(3, 0), new Point(2, 0), new Point(2, 1), new Point(1, 1), new Point(1, 2), new Point(0, 1), new Point(0, 2)});
    private static final Block BASE = (Block)ModBlocks.FLAVOLITE.tiles.get();
    private static final Block PEDESTAL = (Block)ModBlocks.ETERNAL_PEDESTAL.get();
    private static final Block FRAME = (Block)ModBlocks.FLAVOLITE_RUNED_ETERNAL.get();
    private static final Block PORTAL = (Block)ModBlocks.END_PORTAL_BLOCK.get();
    private static final BooleanProperty ACTIVE = BlockProperties.ACTIVATED;
    private World world;
    private Direction.Axis axis;
    private BlockPos center;
    private BlockPos exit;
    private boolean active = false;

    public EternalRitual(World world) {
        this.world = world;
    }

    public EternalRitual(World world, BlockPos initial) {
        this(world);
        this.configure(initial);
    }

    public void setWorld(World world) {
        this.world = world;
    }

    private boolean isInvalid() {
        return this.world == null || this.world.func_201670_d() || this.center == null || this.axis == null || this.world.func_234923_W_() == World.field_234919_h_;
    }

    public void checkStructure() {
        Direction moveY;
        Direction moveX;
        if (this.isInvalid()) {
            return;
        }
        if (Direction.Axis.X == this.axis) {
            moveX = Direction.EAST;
            moveY = Direction.NORTH;
        } else {
            moveX = Direction.SOUTH;
            moveY = Direction.EAST;
        }
        boolean valid = this.checkFrame();
        Item item = null;
        for (Point pos : STRUCTURE_MAP) {
            BlockPos.Mutable checkPos = this.center.func_239590_i_();
            checkPos.func_189534_c(moveX, pos.x).func_189534_c(moveY, pos.y);
            if (!(valid &= this.isActive((BlockPos)checkPos))) continue;
            EternalPedestalTileEntity pedestal = (EternalPedestalTileEntity)this.world.func_175625_s((BlockPos)checkPos);
            Item pItem = pedestal.getStack().func_77973_b();
            if (item == null) {
                item = pItem;
                continue;
            }
            if (item.equals(pItem)) continue;
            valid = false;
        }
        if (valid && item != null) {
            this.activatePortal(item);
        }
    }

    private boolean checkFrame() {
        BlockPos framePos = this.center.func_177977_b();
        Direction moveDir = Direction.Axis.X == this.axis ? Direction.NORTH : Direction.EAST;
        boolean valid = true;
        for (Point point : FRAME_MAP) {
            BlockPos.Mutable pos = framePos.func_239590_i_().func_189534_c(moveDir, point.x).func_189534_c(Direction.UP, point.y);
            BlockState state = this.world.func_180495_p((BlockPos)pos);
            valid &= state.func_177230_c() instanceof RunedFlavoliteBlock;
            pos = framePos.func_239590_i_().func_189534_c(moveDir, -point.x).func_189534_c(Direction.UP, point.y);
            state = this.world.func_180495_p((BlockPos)pos);
            valid &= state.func_177230_c() instanceof RunedFlavoliteBlock;
        }
        return valid;
    }

    public boolean isActive() {
        return this.active;
    }

    private void activatePortal(Item item) {
        if (this.active) {
            return;
        }
        int state = EndPortals.getPortalState(Registry.field_212630_s.func_177774_c((Object)item));
        this.activatePortal(this.world, this.center, state);
        this.doEffects((ServerWorld)this.world, this.center);
        if (this.exit == null) {
            this.exit = this.findPortalPos(state);
        } else {
            World targetWorld = this.getTargetWorld(state);
            if (targetWorld.func_180495_p(this.exit.func_177984_a()).func_203425_a((Block)ModBlocks.END_PORTAL_BLOCK.get())) {
                this.exit = this.findPortalPos(state);
            } else {
                this.activatePortal(targetWorld, this.exit, state);
            }
        }
        this.active = true;
    }

    private void doEffects(ServerWorld serverWorld, BlockPos center) {
        Direction moveY;
        Direction moveX;
        if (Direction.Axis.X == this.axis) {
            moveX = Direction.EAST;
            moveY = Direction.NORTH;
        } else {
            moveX = Direction.SOUTH;
            moveY = Direction.EAST;
        }
        for (Point pos : STRUCTURE_MAP) {
            BlockPos.Mutable p = center.func_239590_i_();
            p.func_189534_c(moveX, pos.x).func_189534_c(moveY, pos.y);
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 1.5, (double)p.func_177952_p() + 0.5, 20, 0.0, 0.0, 0.0, 1.0);
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_239819_as_, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 1.5, (double)p.func_177952_p() + 0.5, 20, 0.0, 0.0, 0.0, 0.3);
        }
        serverWorld.func_184133_a(null, center, SoundEvents.field_193782_bq, SoundCategory.NEUTRAL, 16.0f, 1.0f);
    }

    private void activatePortal(World world, BlockPos center, int dim) {
        BlockPos framePos = center.func_177977_b();
        Direction moveDir = Direction.Axis.X == this.axis ? Direction.NORTH : Direction.EAST;
        BlockState frame = (BlockState)FRAME.func_176223_P().func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
        FRAME_MAP.forEach(point -> {
            BlockPos.Mutable pos = framePos.func_239590_i_().func_189534_c(moveDir, point.x).func_189534_c(Direction.UP, point.y);
            BlockState state = world.func_180495_p((BlockPos)pos);
            if (state.func_235901_b_((Property)ACTIVE) && !((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
                world.func_175656_a((BlockPos)pos, frame);
            }
            if ((state = world.func_180495_p((BlockPos)(pos = framePos.func_239590_i_().func_189534_c(moveDir, -point.x).func_189534_c(Direction.UP, point.y)))).func_235901_b_((Property)ACTIVE) && !((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
                world.func_175656_a((BlockPos)pos, frame);
            }
        });
        Direction.Axis portalAxis = Direction.Axis.X == this.axis ? Direction.Axis.Z : Direction.Axis.X;
        BlockState portal = (BlockState)((BlockState)PORTAL.func_176223_P().func_206870_a((Property)EndPortalBlock.field_176550_a, (Comparable)portalAxis)).func_206870_a((Property)EndPortalBlock.PORTAL, (Comparable)Integer.valueOf(dim));
        BlockParticleData effect = new BlockParticleData(ParticleTypes.field_197611_d, portal);
        ServerWorld serverWorld = (ServerWorld)world;
        PORTAL_MAP.forEach(arg_0 -> EternalRitual.lambda$activatePortal$1(center, moveDir, world, portal, serverWorld, (IParticleData)effect, arg_0));
    }

    public void removePortal(int state) {
        if (!this.active || this.isInvalid()) {
            return;
        }
        World targetWorld = this.getTargetWorld(state);
        this.removePortal(this.world, this.center);
        this.removePortal(targetWorld, this.exit);
    }

    private void removePortal(World world, BlockPos center) {
        BlockPos framePos = center.func_177977_b();
        Direction moveDir = Direction.Axis.X == this.axis ? Direction.NORTH : Direction.EAST;
        FRAME_MAP.forEach(point -> {
            BlockPos.Mutable pos = framePos.func_239590_i_().func_189534_c(moveDir, point.x).func_189534_c(Direction.UP, point.y);
            BlockState state = world.func_180495_p((BlockPos)pos);
            if (state.func_203425_a(FRAME) && ((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
                world.func_175656_a((BlockPos)pos, (BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
            if ((state = world.func_180495_p((BlockPos)(pos = framePos.func_239590_i_().func_189534_c(moveDir, -point.x).func_189534_c(Direction.UP, point.y)))).func_203425_a(FRAME) && ((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
                world.func_175656_a((BlockPos)pos, (BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        });
        PORTAL_MAP.forEach(point -> {
            BlockPos.Mutable pos = center.func_239590_i_().func_189534_c(moveDir, point.x).func_189534_c(Direction.UP, point.y);
            if (world.func_180495_p((BlockPos)pos).func_203425_a(PORTAL)) {
                world.func_217377_a((BlockPos)pos, false);
            }
            if (world.func_180495_p((BlockPos)(pos = center.func_239590_i_().func_189534_c(moveDir, -point.x).func_189534_c(Direction.UP, point.y))).func_203425_a(PORTAL)) {
                world.func_217377_a((BlockPos)pos, false);
            }
        });
        this.active = false;
    }

    private BlockPos findPortalPos(int state) {
        Direction.Axis portalAxis;
        ServerWorld targetWorld = (ServerWorld)this.getTargetWorld(state);
        DimensionType type = Objects.requireNonNull(targetWorld.func_230315_m_());
        double mult = type.func_242724_f();
        BlockPos.Mutable basePos = this.center.func_239590_i_().func_189532_c((double)this.center.func_177958_n() / mult, (double)this.center.func_177956_o(), (double)this.center.func_177952_p() / mult);
        Direction.Axis axis = portalAxis = Direction.Axis.X == this.axis ? Direction.Axis.Z : Direction.Axis.X;
        if (this.checkIsAreaValid((World)targetWorld, (BlockPos)basePos, portalAxis)) {
            EternalRitual.generatePortal((World)targetWorld, (BlockPos)basePos, portalAxis);
            return basePos.func_185334_h();
        }
        Direction direction = Direction.EAST;
        BlockPos.Mutable checkPos = basePos.func_239590_i_();
        for (int step = 1; step < 128; ++step) {
            for (int i = 0; i < step >> 1; ++i) {
                IChunk chunk = this.world.func_217349_x((BlockPos)checkPos);
                if (chunk != null) {
                    int ceil = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, checkPos.func_177958_n() & 0xF, checkPos.func_177952_p() & 0xF) + 1;
                    if (ceil < 2) continue;
                    checkPos.func_185336_p(ceil);
                    while (checkPos.func_177956_o() > 2) {
                        if (this.checkIsAreaValid((World)targetWorld, (BlockPos)checkPos, portalAxis)) {
                            EternalRitual.generatePortal((World)targetWorld, (BlockPos)checkPos, portalAxis);
                            return checkPos.func_185334_h();
                        }
                        checkPos.func_189536_c(Direction.DOWN);
                    }
                }
                checkPos.func_189536_c(direction);
            }
            direction = direction.func_176746_e();
        }
        if (targetWorld.func_234923_W_() == World.field_234920_i_) {
            Features.field_243945_e.func_242765_a((ISeedReader)targetWorld, targetWorld.func_72863_F().func_201711_g(), new Random(basePos.func_218275_a()), basePos.func_177977_b());
        } else {
            basePos.func_185336_p(targetWorld.func_217349_x((BlockPos)basePos).func_201576_a(Heightmap.Type.WORLD_SURFACE, basePos.func_177958_n(), basePos.func_177952_p()) + 1);
            ModConfiguredFeatures.OVERWORLD_ISLAND.func_242765_a((ISeedReader)targetWorld, targetWorld.func_72863_F().func_201711_g(), new Random(basePos.func_218275_a()), basePos.func_177977_b());
        }
        EternalRitual.generatePortal((World)targetWorld, (BlockPos)basePos, portalAxis);
        return basePos.func_185334_h();
    }

    private World getTargetWorld(int state) {
        if (this.world.func_234923_W_() == World.field_234920_i_) {
            return EndPortals.getWorld(this.world.func_73046_m(), state);
        }
        return Objects.requireNonNull(this.world.func_73046_m()).func_71218_a(World.field_234920_i_);
    }

    private boolean checkIsAreaValid(World world, BlockPos pos, Direction.Axis axis) {
        if (!this.isBaseValid(world, pos, axis)) {
            return false;
        }
        return EternalRitual.checkArea(world, pos, axis);
    }

    private boolean isBaseValid(World world, BlockPos pos, Direction.Axis axis) {
        boolean solid = true;
        if (axis.equals((Object)Direction.Axis.X)) {
            pos = pos.func_177977_b().func_177982_a(0, 0, -3);
            for (int i = 0; i < 7; ++i) {
                BlockPos checkPos = pos.func_177982_a(0, 0, i);
                BlockState state = world.func_180495_p(checkPos);
                solid &= this.validBlock(world, checkPos, state);
            }
        } else {
            pos = pos.func_177977_b().func_177982_a(-3, 0, 0);
            for (int i = 0; i < 7; ++i) {
                BlockPos checkPos = pos.func_177982_a(i, 0, 0);
                BlockState state = world.func_180495_p(checkPos);
                solid &= this.validBlock(world, checkPos, state);
            }
        }
        return solid;
    }

    private boolean validBlock(World world, BlockPos pos, BlockState state) {
        return state.func_215686_e((IBlockReader)world, pos) && state.func_200015_d((IBlockReader)world, pos);
    }

    public static void generatePortal(World world, BlockPos center, Direction.Axis axis) {
        BlockPos framePos = center.func_177977_b();
        Direction moveDir = Direction.Axis.X == axis ? Direction.EAST : Direction.NORTH;
        BlockState frame = (BlockState)FRAME.func_176223_P().func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
        FRAME_MAP.forEach(point -> {
            BlockPos.Mutable pos = framePos.func_239590_i_().func_189534_c(moveDir, point.x).func_189534_c(Direction.UP, point.y);
            world.func_175656_a((BlockPos)pos, frame);
            pos = framePos.func_239590_i_().func_189534_c(moveDir, -point.x).func_189534_c(Direction.UP, point.y);
            world.func_175656_a((BlockPos)pos, frame);
        });
        BlockState portal = (BlockState)PORTAL.func_176223_P().func_206870_a((Property)EndPortalBlock.field_176550_a, (Comparable)axis);
        PORTAL_MAP.forEach(point -> {
            BlockPos.Mutable pos = center.func_239590_i_().func_189534_c(moveDir, point.x).func_189534_c(Direction.UP, point.y);
            world.func_175656_a((BlockPos)pos, portal);
            pos = center.func_239590_i_().func_189534_c(moveDir, -point.x).func_189534_c(Direction.UP, point.y);
            world.func_175656_a((BlockPos)pos, portal);
        });
        EternalRitual.generateBase(world, framePos, moveDir);
    }

    private static void generateBase(World world, BlockPos center, Direction moveX) {
        BlockState base = BASE.func_176223_P();
        Direction moveY = moveX.func_176746_e();
        BASE_MAP.forEach(point -> {
            BlockPos.Mutable pos = center.func_239590_i_().func_189534_c(moveX, point.x).func_189534_c(moveY, point.y);
            world.func_175656_a((BlockPos)pos, base);
            pos = center.func_239590_i_().func_189534_c(moveX, -point.x).func_189534_c(moveY, point.y);
            world.func_175656_a((BlockPos)pos, base);
            pos = center.func_239590_i_().func_189534_c(moveX, point.x).func_189534_c(moveY, -point.y);
            world.func_175656_a((BlockPos)pos, base);
            pos = center.func_239590_i_().func_189534_c(moveX, -point.x).func_189534_c(moveY, -point.y);
            world.func_175656_a((BlockPos)pos, base);
        });
    }

    public static boolean checkArea(World world, BlockPos center, Direction.Axis axis) {
        Direction moveDir = Direction.Axis.X == axis ? Direction.NORTH : Direction.EAST;
        for (BlockPos checkPos : BlockPos.func_218278_a((BlockPos)center.func_177972_a(moveDir.func_176746_e()), (BlockPos)center.func_177972_a(moveDir.func_176735_f()))) {
            for (Point point : PORTAL_MAP) {
                BlockPos.Mutable pos = checkPos.func_239590_i_().func_189534_c(moveDir, point.x).func_189534_c(Direction.UP, point.y);
                BlockState state = world.func_180495_p((BlockPos)pos);
                if (EternalRitual.isStateInvalid(state)) {
                    return false;
                }
                pos = checkPos.func_239590_i_().func_189534_c(moveDir, -point.x).func_189534_c(Direction.UP, point.y);
                state = world.func_180495_p((BlockPos)pos);
                if (!EternalRitual.isStateInvalid(state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isStateInvalid(BlockState state) {
        if (!state.func_204520_s().func_206888_e()) {
            return true;
        }
        Material material = state.func_185904_a();
        return !material.func_76222_j() && !material.equals(Material.field_151585_k);
    }

    public void configure(BlockPos initial) {
        BlockPos checkPos = initial.func_177965_g(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = initial.func_177965_g(6);
            return;
        }
        checkPos = initial.func_177985_f(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = initial.func_177985_f(6);
            return;
        }
        checkPos = initial.func_177970_e(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = initial.func_177970_e(6);
            return;
        }
        checkPos = initial.func_177964_d(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = initial.func_177964_d(6);
            return;
        }
        checkPos = initial.func_177964_d(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = this.hasPedestal(checkPos = checkPos.func_177965_g(8)) ? initial.func_177964_d(5).func_177965_g(4) : initial.func_177964_d(5).func_177985_f(4);
            return;
        }
        checkPos = initial.func_177970_e(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = this.hasPedestal(checkPos = checkPos.func_177965_g(8)) ? initial.func_177970_e(5).func_177965_g(4) : initial.func_177970_e(5).func_177985_f(4);
            return;
        }
        checkPos = initial.func_177965_g(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = this.hasPedestal(checkPos = checkPos.func_177970_e(8)) ? initial.func_177965_g(5).func_177970_e(4) : initial.func_177965_g(5).func_177964_d(4);
            return;
        }
        checkPos = initial.func_177985_f(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = this.hasPedestal(checkPos = checkPos.func_177970_e(8)) ? initial.func_177985_f(5).func_177970_e(4) : initial.func_177985_f(5).func_177964_d(4);
            return;
        }
    }

    private boolean hasPedestal(BlockPos pos) {
        return this.world.func_180495_p(pos).func_203425_a(PEDESTAL);
    }

    private boolean isActive(BlockPos pos) {
        BlockState state = this.world.func_180495_p(pos);
        if (state.func_203425_a(PEDESTAL)) {
            EternalPedestalTileEntity pedestal = (EternalPedestalTileEntity)this.world.func_175625_s(pos);
            assert (pedestal != null);
            if (!pedestal.hasRitual()) {
                pedestal.linkRitual(this);
            }
            return (Boolean)state.func_177229_b((Property)ACTIVE);
        }
        return false;
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_218657_a("center", (INBT)NBTUtil.func_186859_a((BlockPos)this.center));
        if (this.exit != null) {
            compound.func_218657_a("exit", (INBT)NBTUtil.func_186859_a((BlockPos)this.exit));
        }
        compound.func_74778_a("axis", this.axis.func_176719_a());
        compound.func_74757_a("active", this.active);
        return compound;
    }

    public void read(CompoundNBT nbt) {
        this.axis = Direction.Axis.func_176717_a((String)nbt.func_74779_i("axis"));
        this.center = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("center"));
        this.active = nbt.func_74767_n("active");
        if (nbt.func_74764_b("exit")) {
            this.exit = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("exit"));
        }
    }

    private static /* synthetic */ void lambda$activatePortal$1(BlockPos center, Direction moveDir, World world, BlockState portal, ServerWorld serverWorld, IParticleData effect, Point point) {
        BlockPos.Mutable pos = center.func_239590_i_().func_189534_c(moveDir, point.x).func_189534_c(Direction.UP, point.y);
        if (!world.func_180495_p((BlockPos)pos).func_203425_a(PORTAL)) {
            world.func_175656_a((BlockPos)pos, portal);
            serverWorld.func_195598_a(effect, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_239819_as_, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 10, 0.5, 0.5, 0.5, 0.3);
        }
        if (!world.func_180495_p((BlockPos)(pos = center.func_239590_i_().func_189534_c(moveDir, -point.x).func_189534_c(Direction.UP, point.y))).func_203425_a(PORTAL)) {
            world.func_175656_a((BlockPos)pos, portal);
            serverWorld.func_195598_a(effect, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_239819_as_, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 10, 0.5, 0.5, 0.5, 0.3);
        }
    }
}

