/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block.material;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import mod.beethoven92.betterendforge.common.block.ModLanternBlock;
import mod.beethoven92.betterendforge.common.block.template.EndFurnaceBlock;
import mod.beethoven92.betterendforge.common.block.template.PedestalBlock;
import mod.beethoven92.betterendforge.common.block.template.PillarBlockTemplate;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StoneButtonBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraftforge.fml.RegistryObject;

public class StoneMaterial {
    private static final List<StoneMaterial> MATERIALS = new ArrayList<StoneMaterial>();
    public final String name;
    public final RegistryObject<Block> stone;
    public final RegistryObject<Block> polished;
    public final RegistryObject<Block> tiles;
    public final RegistryObject<Block> pillar;
    public final RegistryObject<Block> stairs;
    public final RegistryObject<Block> slab;
    public final RegistryObject<Block> wall;
    public final RegistryObject<Block> button;
    public final RegistryObject<Block> pressure_plate;
    public final RegistryObject<Block> pedestal;
    public final RegistryObject<Block> lantern;
    public final RegistryObject<Block> bricks;
    public final RegistryObject<Block> brick_stairs;
    public final RegistryObject<Block> brick_slab;
    public final RegistryObject<Block> brick_wall;
    public final RegistryObject<Block> furnace;

    public StoneMaterial(String name, MaterialColor color) {
        this.name = name;
        AbstractBlock.Properties material = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)color).func_235861_h_().func_200948_a(3.0f, 9.0f);
        this.stone = ModBlocks.registerBlockWithDefaultItem(name, () -> new Block(material));
        this.polished = ModBlocks.registerBlockWithDefaultItem(name + "_polished", () -> new Block(material));
        this.tiles = ModBlocks.registerBlockWithDefaultItem(name + "_tiles", () -> new Block(material));
        this.pillar = ModBlocks.registerBlockWithDefaultItem(name + "_pillar", () -> new PillarBlockTemplate(material));
        this.stairs = ModBlocks.registerBlockWithDefaultItem(name + "_stairs", () -> new StairsBlock(() -> ((Block)this.stone.get()).func_176223_P(), material));
        this.slab = ModBlocks.registerBlockWithDefaultItem(name + "_slab", () -> new SlabBlock(material));
        this.wall = ModBlocks.registerBlockWithDefaultItem(name + "_wall", () -> new WallBlock(material));
        this.button = ModBlocks.registerBlockWithDefaultItem(name + "_button", () -> new StoneButtonBlock(material));
        this.pressure_plate = ModBlocks.registerBlockWithDefaultItem(name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, material));
        this.pedestal = ModBlocks.registerBlockWithDefaultItem(name + "_pedestal", () -> new PedestalBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)color).func_235861_h_().func_200948_a(3.0f, 9.0f).func_235838_a_(PedestalBlock.light())));
        this.lantern = ModBlocks.registerBlockWithDefaultItem(name + "_lantern", () -> new ModLanternBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)color).func_235861_h_().func_200948_a(3.0f, 9.0f).func_235838_a_(s -> 15)));
        this.bricks = ModBlocks.registerBlockWithDefaultItem(name + "_bricks", () -> new Block(material));
        this.brick_stairs = ModBlocks.registerBlockWithDefaultItem(name + "_bricks_stairs", () -> new StairsBlock(() -> ((Block)this.bricks.get()).func_176223_P(), material));
        this.brick_slab = ModBlocks.registerBlockWithDefaultItem(name + "_bricks_slab", () -> new SlabBlock(material));
        this.brick_wall = ModBlocks.registerBlockWithDefaultItem(name + "_bricks_wall", () -> new WallBlock(material));
        this.furnace = ModBlocks.registerBlockWithDefaultItem(name + "_furnace", () -> new EndFurnaceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)this.bricks.get())).func_235838_a_(state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? 13 : 0)));
        MATERIALS.add(this);
    }

    public static Iterable<StoneMaterial> getMaterials() {
        return Iterables.unmodifiableIterable(MATERIALS);
    }
}

