/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block;

import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlimeBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public class JellyshroomCapBlock
extends SlimeBlock {
    public static final IntegerProperty COLOR = IntegerProperty.func_177719_a((String)"color", (int)0, (int)7);
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(0L);
    private final Vector3i colorStart;
    private final Vector3i colorEnd;
    private final int coloritem;

    public JellyshroomCapBlock(int r1, int g1, int b1, int r2, int g2, int b2) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180399_cE));
        this.colorStart = new Vector3i(r1, g1, b1);
        this.colorEnd = new Vector3i(r2, g2, b2);
        this.coloritem = ModMathHelper.color(r1 + r2 >> 1, g1 + g2 >> 1, b1 + b2 >> 1);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        double px = (double)context.func_195995_a().func_177958_n() * 0.1;
        double py = (double)context.func_195995_a().func_177956_o() * 0.1;
        double pz = (double)context.func_195995_a().func_177952_p() * 0.1;
        return (BlockState)this.func_176223_P().func_206870_a((Property)COLOR, (Comparable)Integer.valueOf(ModMathHelper.floor(NOISE.eval(px, py, pz) * 3.5 + 4.0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{COLOR});
    }

    public int getBlockColor(BlockState state) {
        float delta = (float)((Integer)state.func_177229_b((Property)COLOR)).intValue() / 7.0f;
        int r = MathHelper.func_76141_d((float)(MathHelper.func_219799_g((float)delta, (float)((float)this.colorStart.func_177958_n() / 255.0f), (float)((float)this.colorEnd.func_177958_n() / 255.0f)) * 255.0f));
        int g = MathHelper.func_76141_d((float)(MathHelper.func_219799_g((float)delta, (float)((float)this.colorStart.func_177956_o() / 255.0f), (float)((float)this.colorEnd.func_177956_o() / 255.0f)) * 255.0f));
        int b = MathHelper.func_76141_d((float)(MathHelper.func_219799_g((float)delta, (float)((float)this.colorStart.func_177952_p() / 255.0f), (float)((float)this.colorEnd.func_177952_p() / 255.0f)) * 255.0f));
        return ModMathHelper.color(r, g, b);
    }

    public static int getItemColor(ItemStack stack) {
        BlockItem blockItem;
        if (stack.func_77973_b() instanceof BlockItem && (blockItem = (BlockItem)stack.func_77973_b()).func_179223_d() instanceof JellyshroomCapBlock) {
            JellyshroomCapBlock block = (JellyshroomCapBlock)blockItem.func_179223_d();
            return block.coloritem;
        }
        return 0;
    }
}

