/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.shape;

import org.popcraft.chunky.Selection;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.ShapeUtil;

public class Star
extends AbstractPolygon {
    private final double p1x;
    private final double p1z;
    private final double p2x;
    private final double p2z;
    private final double p3x;
    private final double p3z;
    private final double p4x;
    private final double p4z;
    private final double p5x;
    private final double p5z;
    private final double i1x;
    private final double i1z;
    private final double i2x;
    private final double i2z;
    private final double i3x;
    private final double i3z;
    private final double i4x;
    private final double i4z;
    private final double i5x;
    private final double i5z;

    public Star(Selection selection, boolean chunkAligned) {
        super(selection, chunkAligned);
        this.p1x = this.centerX + this.radiusX * Math.cos(Math.toRadians(54.0));
        this.p1z = this.centerZ + this.radiusX * Math.sin(Math.toRadians(54.0));
        this.p2x = this.centerX + this.radiusX * Math.cos(Math.toRadians(126.0));
        this.p2z = this.centerZ + this.radiusX * Math.sin(Math.toRadians(126.0));
        this.p3x = this.centerX + this.radiusX * Math.cos(Math.toRadians(198.0));
        this.p3z = this.centerZ + this.radiusX * Math.sin(Math.toRadians(198.0));
        this.p4x = this.centerX + this.radiusX * Math.cos(Math.toRadians(270.0));
        this.p4z = this.centerZ + this.radiusX * Math.sin(Math.toRadians(270.0));
        this.p5x = this.centerX + this.radiusX * Math.cos(Math.toRadians(342.0));
        this.p5z = this.centerZ + this.radiusX * Math.sin(Math.toRadians(342.0));
        double[] i1 = ShapeUtil.intersection(this.p1x, this.p1z, this.p3x, this.p3z, this.p2x, this.p2z, this.p5x, this.p5z).orElse(new double[]{this.p1x, this.p1z});
        double[] i2 = ShapeUtil.intersection(this.p1x, this.p1z, this.p3x, this.p3z, this.p2x, this.p2z, this.p4x, this.p4z).orElse(new double[]{this.p2x, this.p2z});
        double[] i3 = ShapeUtil.intersection(this.p2x, this.p2z, this.p4x, this.p4z, this.p3x, this.p3z, this.p5x, this.p5z).orElse(new double[]{this.p3x, this.p3z});
        double[] i4 = ShapeUtil.intersection(this.p3x, this.p3z, this.p5x, this.p5z, this.p1x, this.p1z, this.p4x, this.p4z).orElse(new double[]{this.p4x, this.p4z});
        double[] i5 = ShapeUtil.intersection(this.p1x, this.p1z, this.p4x, this.p4z, this.p2x, this.p2z, this.p5x, this.p5z).orElse(new double[]{this.p5x, this.p5z});
        this.i1x = i1[0];
        this.i1z = i1[1];
        this.i2x = i2[0];
        this.i2z = i2[1];
        this.i3x = i3[0];
        this.i3z = i3[1];
        this.i4x = i4[0];
        this.i4z = i4[1];
        this.i5x = i5[0];
        this.i5z = i5[1];
    }

    @Override
    public double[] pointsX() {
        return new double[]{this.p1x, this.i1x, this.p2x, this.i2x, this.p3x, this.i3x, this.p4x, this.i4x, this.p5x, this.i5x};
    }

    @Override
    public double[] pointsZ() {
        return new double[]{this.p1z, this.i1z, this.p2z, this.i2z, this.p3z, this.i3z, this.p4z, this.i4z, this.p5z, this.i5z};
    }

    @Override
    public boolean isBounding(double x, double z) {
        boolean inside13 = ShapeUtil.insideLine(this.p1x, this.p1z, this.p3x, this.p3z, x, z);
        boolean inside24 = ShapeUtil.insideLine(this.p2x, this.p2z, this.p4x, this.p4z, x, z);
        boolean inside35 = ShapeUtil.insideLine(this.p3x, this.p3z, this.p5x, this.p5z, x, z);
        boolean inside41 = ShapeUtil.insideLine(this.p4x, this.p4z, this.p1x, this.p1z, x, z);
        if (inside13 && inside24 && inside35 && inside41) {
            return true;
        }
        boolean inside52 = ShapeUtil.insideLine(this.p5x, this.p5z, this.p2x, this.p2z, x, z);
        if (inside24 && inside35 && inside41 && inside52) {
            return true;
        }
        if (inside35 && inside41 && inside52 && inside13) {
            return true;
        }
        if (inside41 && inside52 && inside13 && inside24) {
            return true;
        }
        return inside52 && inside13 && inside24 && inside35;
    }

    @Override
    public String name() {
        return "star";
    }
}

