/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.shape;

import java.util.Optional;

public class ShapeUtil {
    public static boolean insideLine(double ax, double az, double bx, double bz, double cx, double cz) {
        return (bx - ax) * (cz - az) > (bz - az) * (cx - ax);
    }

    public static Optional<double[]> intersection(double l1p1x, double l1p1z, double l1p2x, double l1p2z, double l2p1x, double l2p1z, double l2p2x, double l2p2z) {
        double l1dx = l1p2x - l1p1x;
        double l2dx = l2p2x - l2p1x;
        if (l1dx == 0.0 && l2dx == 0.0) {
            return Optional.empty();
        }
        double l1dz = l1p2z - l1p1z;
        double l2dz = l2p2z - l2p1z;
        double l2m = l2dz / l2dx;
        double l2b = l2p1z - l2m * l2p1x;
        if (l1dx == 0.0) {
            return Optional.of(new double[]{l1p1x, l2m * l1p1x + l2b});
        }
        double l1m = l1dz / l1dx;
        double l1b = l1p1z - l1m * l1p1x;
        if (l2dx == 0.0) {
            return Optional.of(new double[]{l2p1x, l1m * l2p1x + l1b});
        }
        if (l1m == l2m) {
            return Optional.empty();
        }
        double a1 = -l1m;
        double c1 = -l1b;
        double a2 = -l2m;
        double c2 = -l2b;
        double ix = (c2 - c1) / (a1 - a2);
        double iz = (a2 * c1 - a1 * c2) / (a1 - a2);
        return Optional.of(new double[]{ix, iz});
    }

    public static double[] pointOnEllipse(double centerX, double centerZ, double radiusX, double radiusZ, double angle) {
        double pointX = centerX + radiusX * Math.cos(angle);
        double pointZ = centerZ + radiusZ * Math.sin(angle);
        return new double[]{pointX, pointZ};
    }
}

