/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.shape;

import org.popcraft.chunky.Selection;
import org.popcraft.chunky.shape.Circle;
import org.popcraft.chunky.shape.Diamond;
import org.popcraft.chunky.shape.Ellipse;
import org.popcraft.chunky.shape.Pentagon;
import org.popcraft.chunky.shape.Rectangle;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.Square;
import org.popcraft.chunky.shape.Star;
import org.popcraft.chunky.shape.Triangle;

public class ShapeFactory {
    public static Shape getShape(Selection selection) {
        return ShapeFactory.getShape(selection, true);
    }

    public static Shape getShape(Selection selection, boolean chunkAligned) {
        switch (selection.shape()) {
            case "circle": {
                return new Circle(selection, chunkAligned);
            }
            case "diamond": {
                return new Diamond(selection, chunkAligned);
            }
            case "oval": 
            case "ellipse": {
                return new Ellipse(selection, chunkAligned);
            }
            case "pentagon": {
                return new Pentagon(selection, chunkAligned);
            }
            case "rectangle": {
                return new Rectangle(selection, chunkAligned);
            }
            case "star": {
                return new Star(selection, chunkAligned);
            }
            case "triangle": {
                return new Triangle(selection, chunkAligned);
            }
        }
        return new Square(selection, chunkAligned);
    }
}

