/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.shape;

import org.popcraft.chunky.Selection;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.ShapeUtil;

public class Pentagon
extends AbstractPolygon {
    private final double p1x;
    private final double p1z;
    private final double p2x;
    private final double p2z;
    private final double p3x;
    private final double p3z;
    private final double p4x;
    private final double p4z;
    private final double p5x;
    private final double p5z;

    public Pentagon(Selection selection, boolean chunkAligned) {
        super(selection, chunkAligned);
        this.p1x = this.centerX + this.radiusX * Math.cos(Math.toRadians(54.0));
        this.p1z = this.centerZ + this.radiusX * Math.sin(Math.toRadians(54.0));
        this.p2x = this.centerX + this.radiusX * Math.cos(Math.toRadians(126.0));
        this.p2z = this.centerZ + this.radiusX * Math.sin(Math.toRadians(126.0));
        this.p3x = this.centerX + this.radiusX * Math.cos(Math.toRadians(198.0));
        this.p3z = this.centerZ + this.radiusX * Math.sin(Math.toRadians(198.0));
        this.p4x = this.centerX + this.radiusX * Math.cos(Math.toRadians(270.0));
        this.p4z = this.centerZ + this.radiusX * Math.sin(Math.toRadians(270.0));
        this.p5x = this.centerX + this.radiusX * Math.cos(Math.toRadians(342.0));
        this.p5z = this.centerZ + this.radiusX * Math.sin(Math.toRadians(342.0));
    }

    @Override
    public double[] pointsX() {
        return new double[]{this.p1x, this.p2x, this.p3x, this.p4x, this.p5x};
    }

    @Override
    public double[] pointsZ() {
        return new double[]{this.p1z, this.p2z, this.p3z, this.p4z, this.p5z};
    }

    @Override
    public boolean isBounding(double x, double z) {
        boolean inside12 = ShapeUtil.insideLine(this.p1x, this.p1z, this.p2x, this.p2z, x, z);
        boolean inside23 = ShapeUtil.insideLine(this.p2x, this.p2z, this.p3x, this.p3z, x, z);
        boolean inside34 = ShapeUtil.insideLine(this.p3x, this.p3z, this.p4x, this.p4z, x, z);
        boolean inside45 = ShapeUtil.insideLine(this.p4x, this.p4z, this.p5x, this.p5z, x, z);
        boolean inside51 = ShapeUtil.insideLine(this.p5x, this.p5z, this.p1x, this.p1z, x, z);
        return inside12 && inside23 && inside34 && inside45 && inside51;
    }

    @Override
    public String name() {
        return "pentagon";
    }
}

