/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.FolderName;
import org.popcraft.chunky.platform.Border;
import org.popcraft.chunky.platform.ForgeBorder;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Coordinate;

public class ForgeWorld
implements World {
    private static final TicketType<Unit> CHUNKY = TicketType.func_219484_a((String)"chunky", (unit, unit2) -> 0);
    private final ServerWorld world;
    private final Border worldBorder;

    public ForgeWorld(ServerWorld world) {
        this.world = world;
        this.worldBorder = new ForgeBorder(world.func_175723_af());
    }

    @Override
    public String getName() {
        return this.world.func_234923_W_().func_240901_a_().toString();
    }

    @Override
    public boolean isChunkGenerated(int x, int z) {
        CompoundNBT levelCompoundTag;
        CompoundNBT chunkNbt;
        if (Thread.currentThread() != this.world.func_73046_m().func_213170_ax()) {
            return CompletableFuture.supplyAsync(() -> this.isChunkGenerated(x, z), (Executor)this.world.func_73046_m()).join();
        }
        ChunkManager chunkStorage = this.world.func_72863_F().field_217237_a;
        ChunkPos chunkPos = new ChunkPos(x, z);
        ChunkHolder loadedChunkHolder = chunkStorage.func_219219_b(chunkPos.func_201841_a());
        if (loadedChunkHolder != null && this.getLastAvailableStatus(loadedChunkHolder) == ChunkStatus.field_222617_m) {
            return true;
        }
        ChunkHolder unloadedChunkHolder = (ChunkHolder)chunkStorage.field_219253_g.get(chunkPos.func_201841_a());
        if (unloadedChunkHolder != null && this.getLastAvailableStatus(unloadedChunkHolder) == ChunkStatus.field_222617_m) {
            return true;
        }
        try {
            chunkNbt = chunkStorage.func_219178_f(chunkPos);
        }
        catch (IOException e) {
            return false;
        }
        if (chunkNbt != null && chunkNbt.func_150297_b("Level", 10) && (levelCompoundTag = chunkNbt.func_74775_l("Level")).func_150297_b("Status", 8)) {
            return "full".equals(levelCompoundTag.func_74779_i("Status"));
        }
        return false;
    }

    private ChunkStatus getLastAvailableStatus(ChunkHolder chunkHolder) {
        for (int i = ChunkHolder.field_219310_e.size() - 1; i >= 0; --i) {
            ChunkStatus chunkStatus = (ChunkStatus)ChunkHolder.field_219310_e.get(i);
            if (!chunkHolder.func_219301_a(chunkStatus).getNow(ChunkHolder.field_219306_a).left().isPresent()) continue;
            return chunkStatus;
        }
        return null;
    }

    @Override
    public CompletableFuture<Void> getChunkAtAsync(int x, int z) {
        if (Thread.currentThread() != this.world.func_73046_m().func_213170_ax()) {
            return CompletableFuture.supplyAsync(() -> this.getChunkAtAsync(x, z), (Executor)this.world.func_73046_m()).join();
        }
        CompletableFuture<Void> chunkFuture = new CompletableFuture<Void>();
        ChunkPos chunkPos = new ChunkPos(x, z);
        this.world.func_72863_F().func_217228_a(CHUNKY, chunkPos, 0, (Object)Unit.INSTANCE);
        this.world.func_72863_F().func_217235_l();
        ChunkManager chunkManager = this.world.func_72863_F().field_217237_a;
        ChunkHolder chunkHolder = chunkManager.func_219219_b(chunkPos.func_201841_a());
        if (chunkHolder == null) {
            chunkFuture.complete(null);
            this.world.func_72863_F().func_217222_b(CHUNKY, chunkPos, 0, (Object)Unit.INSTANCE);
        } else {
            chunkHolder.func_219276_a(ChunkStatus.field_222617_m, chunkManager).thenAcceptAsync(either -> {
                chunkFuture.complete(null);
                this.world.func_72863_F().func_217222_b(CHUNKY, chunkPos, 0, (Object)Unit.INSTANCE);
            }, (Executor)this.world.func_73046_m());
        }
        return chunkFuture;
    }

    @Override
    public UUID getUUID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSeaLevel() {
        return this.world.func_181545_F();
    }

    @Override
    public Coordinate getSpawnCoordinate() {
        BlockPos spawnPoint = this.world.func_241135_u_();
        return new Coordinate(spawnPoint.func_177958_n(), spawnPoint.func_177952_p());
    }

    @Override
    public Border getWorldBorder() {
        return this.worldBorder;
    }

    @Override
    public Optional<Path> getEntitiesDirectory() {
        return this.getDirectory("entities");
    }

    @Override
    public Optional<Path> getPOIDirectory() {
        return this.getDirectory("poi");
    }

    @Override
    public Optional<Path> getRegionDirectory() {
        return this.getDirectory("region");
    }

    private Optional<Path> getDirectory(String name) {
        if (name == null) {
            return Optional.empty();
        }
        Path directory = DimensionType.func_236031_a_((RegistryKey)this.world.func_234923_W_(), (File)this.world.func_73046_m().func_240776_a_(FolderName.field_237253_i_).toFile()).toPath().normalize().resolve(name);
        return Files.exists(directory, new LinkOption[0]) ? Optional.of(directory) : Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.world.equals(((ForgeWorld)o).world);
    }

    public int hashCode() {
        return this.world.hashCode();
    }
}

