/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;
import org.popcraft.chunky.ChunkyForge;
import org.popcraft.chunky.integration.Integration;
import org.popcraft.chunky.platform.Config;
import org.popcraft.chunky.platform.ForgeSender;
import org.popcraft.chunky.platform.ForgeWorld;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.Server;
import org.popcraft.chunky.platform.World;

public class ForgeServer
implements Server {
    private final ChunkyForge plugin;
    private final MinecraftServer server;

    public ForgeServer(ChunkyForge plugin, MinecraftServer server) {
        this.plugin = plugin;
        this.server = server;
    }

    @Override
    public Map<String, Integration> getIntegrations() {
        return Collections.emptyMap();
    }

    @Override
    public Optional<World> getWorld(String name) {
        ResourceLocation resourceLocation = ResourceLocation.func_208304_a((String)name);
        if (resourceLocation == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.server.func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)resourceLocation))).map(ForgeWorld::new);
    }

    @Override
    public List<World> getWorlds() {
        ArrayList<World> worlds = new ArrayList<World>();
        this.server.func_212370_w().forEach(world -> worlds.add(new ForgeWorld((ServerWorld)world)));
        return worlds;
    }

    @Override
    public Sender getConsoleSender() {
        return new ForgeSender(this.server.func_195573_aM());
    }

    @Override
    public Config getConfig() {
        return this.plugin.getChunky().getConfig();
    }
}

