/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.listeners;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.CustomServerBossInfo;
import net.minecraft.server.CustomServerBossInfoManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DimensionType;
import net.minecraft.world.server.ServerWorld;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.platform.ForgeWorld;

public class BossBarProgress {
    public static void tick(Chunky chunky, MinecraftServer server) {
        int quietInterval = Math.max(1, chunky.getOptions().getQuietInterval() * 20);
        if (server.func_71259_af() % quietInterval != 0) {
            return;
        }
        for (ServerWorld world : server.func_212370_w()) {
            CustomServerBossInfo bossBar;
            boolean barExists;
            ResourceLocation worldId = world.func_234923_W_().func_240901_a_();
            ResourceLocation barId = ResourceLocation.func_208304_a((String)("chunky:progress_" + worldId.toString().replace(':', '_')));
            if (barId == null) continue;
            CustomServerBossInfoManager bossBarManager = server.func_201300_aS();
            GenerationTask task = chunky.getGenerationTasks().get(new ForgeWorld(world));
            boolean bl = barExists = bossBarManager.func_201384_a(barId) != null;
            if (task == null && !barExists) continue;
            if (barExists) {
                bossBar = bossBarManager.func_201384_a(barId);
            } else {
                bossBar = bossBarManager.func_201379_a(barId, (ITextComponent)new StringTextComponent(barId.toString()));
                if (DimensionType.field_242710_a.equals((Object)worldId)) {
                    bossBar.func_186745_a(BossInfo.Color.GREEN);
                } else if (DimensionType.field_242711_b.equals((Object)worldId)) {
                    bossBar.func_186745_a(BossInfo.Color.RED);
                } else if (DimensionType.field_242712_c.equals((Object)worldId)) {
                    bossBar.func_186745_a(BossInfo.Color.PURPLE);
                } else {
                    bossBar.func_186745_a(BossInfo.Color.BLUE);
                }
            }
            if (bossBar == null) continue;
            boolean silent = chunky.getOptions().isSilent();
            if (silent && bossBar.func_201359_g() || !silent && !bossBar.func_201359_g()) {
                bossBar.func_186758_d(!silent);
            }
            if (task == null) {
                bossBar.func_201360_b();
                bossBarManager.func_201385_a(bossBar);
                continue;
            }
            for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                if (player.func_211513_k(2)) {
                    bossBar.func_186760_a(player);
                    continue;
                }
                bossBar.func_186761_b(player);
            }
            GenerationTask.Progress progress = task.getProgress();
            bossBar.func_186739_a((ITextComponent)new StringTextComponent(String.format("%s | %s%% | %s:%s:%s", worldId, String.format("%.2f", Float.valueOf(progress.getPercentComplete())), String.format("%01d", progress.getHours()), String.format("%02d", progress.getMinutes()), String.format("%02d", progress.getSeconds()))));
            bossBar.func_186735_a(task.getProgress().getPercentComplete() / 100.0f);
        }
    }
}

