/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.integration;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.pl3x.map.api.Key;
import net.pl3x.map.api.LayerProvider;
import net.pl3x.map.api.MapWorld;
import net.pl3x.map.api.Pl3xMap;
import net.pl3x.map.api.Point;
import net.pl3x.map.api.Registry;
import net.pl3x.map.api.SimpleLayerProvider;
import net.pl3x.map.api.marker.Marker;
import net.pl3x.map.api.marker.MarkerOptions;
import org.popcraft.chunky.integration.AbstractMapIntegration;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Circle;
import org.popcraft.chunky.shape.Shape;

public class Pl3xMapIntegration
extends AbstractMapIntegration {
    private static final Key WORLDBORDER_KEY = Key.of((String)"pl3xmap-worldborder");
    private static final Key CHUNKY_KEY = Key.of((String)"chunky");
    private final Pl3xMap pl3xMap;
    private final Map<UUID, LayerProvider> defaultProviders = new HashMap<UUID, LayerProvider>();
    private boolean hideByDefault;
    private int priority;

    public Pl3xMapIntegration(Pl3xMap pl3xMap) {
        this.pl3xMap = pl3xMap;
    }

    @Override
    public void addShapeMarker(World world, Shape shape) {
        this.pl3xMap.getWorldIfEnabled(world.getUUID()).ifPresent(pl3xWorld -> {
            Object marker;
            Registry layerRegistry = pl3xWorld.layerRegistry();
            if (layerRegistry.hasEntry(WORLDBORDER_KEY)) {
                this.defaultProviders.put(pl3xWorld.uuid(), (LayerProvider)layerRegistry.get(WORLDBORDER_KEY));
                layerRegistry.unregister(WORLDBORDER_KEY);
            }
            if (!layerRegistry.hasEntry(CHUNKY_KEY)) {
                layerRegistry.register(CHUNKY_KEY, (Object)SimpleLayerProvider.builder((String)this.label).defaultHidden(this.hideByDefault).layerPriority(1).zIndex(this.priority).build());
            }
            SimpleLayerProvider chunkyLayerProvider = (SimpleLayerProvider)layerRegistry.get(CHUNKY_KEY);
            chunkyLayerProvider.clearMarkers();
            if (shape instanceof AbstractPolygon) {
                double[] pointsZ;
                AbstractPolygon polygon = (AbstractPolygon)shape;
                double[] pointsX = polygon.pointsX();
                if (pointsX.length != (pointsZ = polygon.pointsZ()).length) {
                    return;
                }
                Point[] points = new Point[pointsX.length + 1];
                for (int i = 0; i < pointsX.length; ++i) {
                    points[i] = Point.of((double)pointsX[i], (double)pointsZ[i]);
                }
                points[pointsX.length] = Point.of((double)pointsX[0], (double)pointsZ[0]);
                marker = Marker.polyline((Point[])points);
            } else if (shape instanceof AbstractEllipse) {
                AbstractEllipse ellipse = (AbstractEllipse)shape;
                double[] center = ellipse.getCenter();
                double[] radii = ellipse.getRadii();
                Point centerPoint = Point.of((double)center[0], (double)center[1]);
                marker = ellipse instanceof Circle ? Marker.circle((Point)centerPoint, (double)radii[0]) : this.ellipse(centerPoint, radii[0], radii[1]);
            } else {
                return;
            }
            MarkerOptions markerOptions = MarkerOptions.builder().stroke(true).strokeColor(new Color(this.color)).strokeWeight(this.weight).fill(false).clickTooltip(this.label).build();
            marker.markerOptions(markerOptions);
            chunkyLayerProvider.addMarker(CHUNKY_KEY, (Marker)marker);
        });
    }

    @Override
    public void removeShapeMarker(World world) {
        this.pl3xMap.getWorldIfEnabled(world.getUUID()).ifPresent(this::unregisterLayer);
    }

    @Override
    public void removeAllShapeMarkers() {
        this.pl3xMap.mapWorlds().forEach(this::unregisterLayer);
    }

    private void unregisterLayer(MapWorld mapWorld) {
        LayerProvider defaultProvider;
        Registry layerRegistry = mapWorld.layerRegistry();
        if (!layerRegistry.hasEntry(WORLDBORDER_KEY) && (defaultProvider = this.defaultProviders.get(mapWorld.uuid())) != null) {
            layerRegistry.register(WORLDBORDER_KEY, (Object)defaultProvider);
        }
        if (layerRegistry.hasEntry(CHUNKY_KEY)) {
            ((SimpleLayerProvider)layerRegistry.get(CHUNKY_KEY)).clearMarkers();
            layerRegistry.unregister(CHUNKY_KEY);
        }
    }

    @Override
    public void setOptions(String label, String color, boolean hideByDefault, int priority, int weight) {
        super.setOptions(label, color, hideByDefault, priority, weight);
        this.hideByDefault = hideByDefault;
        this.priority = priority;
    }

    private Marker ellipse(Point center, double radiusX, double radiusZ) {
        int numPoints = 360;
        Point[] points = new Point[numPoints + 1];
        double segmentAngle = Math.PI * 2 / (double)numPoints;
        for (int i = 0; i < numPoints; ++i) {
            double pointX = center.x() + Math.sin(segmentAngle * (double)i) * radiusX;
            double pointZ = center.z() + Math.cos(segmentAngle * (double)i) * radiusZ;
            points[i] = Point.of((double)pointX, (double)pointZ);
        }
        points[numPoints] = Point.of((double)center.x(), (double)(center.z() + radiusZ));
        return Marker.polyline((Point[])points);
    }
}

