/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.integration;

import java.util.HashMap;
import java.util.Map;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.CircleMarker;
import org.dynmap.markers.MarkerDescription;
import org.dynmap.markers.MarkerSet;
import org.popcraft.chunky.integration.AbstractMapIntegration;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Shape;

public class DynmapIntegration
extends AbstractMapIntegration {
    private final MarkerSet markerSet;
    private final Map<World, MarkerDescription> markers;

    public DynmapIntegration(DynmapAPI dynmapAPI) {
        this.markerSet = dynmapAPI.getMarkerAPI().createMarkerSet("chunky.markerset", this.label, null, false);
        this.markers = new HashMap<World, MarkerDescription>();
    }

    @Override
    public void addShapeMarker(World world, Shape shape) {
        this.removeShapeMarker(world);
        if (shape instanceof AbstractPolygon) {
            AbstractPolygon polygon = (AbstractPolygon)shape;
            AreaMarker marker = this.markerSet.createAreaMarker(null, this.label, false, world.getName(), polygon.pointsX(), polygon.pointsZ(), false);
            marker.setLineStyle(this.weight, 1.0, this.color);
            marker.setFillStyle(0.0, 0);
            this.markers.put(world, (MarkerDescription)marker);
        } else if (shape instanceof AbstractEllipse) {
            AbstractEllipse ellipse = (AbstractEllipse)shape;
            double[] center = ellipse.getCenter();
            double[] radii = ellipse.getRadii();
            CircleMarker marker = this.markerSet.createCircleMarker(null, this.label, false, world.getName(), center[0], (double)world.getSeaLevel(), center[1], radii[0], radii[1], false);
            marker.setLineStyle(this.weight, 1.0, this.color);
            marker.setFillStyle(0.0, 0);
            this.markers.put(world, (MarkerDescription)marker);
        }
    }

    @Override
    public void removeShapeMarker(World world) {
        MarkerDescription marker = this.markers.remove(world);
        if (marker != null) {
            marker.deleteMarker();
        }
    }

    @Override
    public void removeAllShapeMarkers() {
        if (this.markerSet != null) {
            this.markerSet.deleteMarkerSet();
        }
        this.markers.clear();
    }

    @Override
    public void setOptions(String label, String color, boolean hideByDefault, int priority, int weight) {
        super.setOptions(label, color, hideByDefault, priority, weight);
        if (this.markerSet != null) {
            this.markerSet.setHideByDefault(hideByDefault);
            this.markerSet.setLayerPriority(priority);
        }
    }
}

