/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.integration;

import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.marker.MarkerAPI;
import de.bluecolored.bluemap.api.marker.MarkerSet;
import de.bluecolored.bluemap.api.marker.ShapeMarker;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.popcraft.chunky.integration.AbstractMapIntegration;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Shape;

public class BlueMapIntegration
extends AbstractMapIntegration {
    private static final String MARKERSET_ID = "chunky";
    private final List<Runnable> pendingMarkers = new ArrayList<Runnable>();
    private BlueMapAPI blueMapAPI;

    public BlueMapIntegration() {
        BlueMapAPI.onEnable(blueMap -> {
            this.blueMapAPI = blueMap;
            this.pendingMarkers.forEach(Runnable::run);
            this.pendingMarkers.clear();
        });
        BlueMapAPI.onDisable(blueMap -> {
            this.blueMapAPI = null;
        });
    }

    @Override
    public void addShapeMarker(World world, Shape shape) {
        de.bluecolored.bluemap.api.marker.Shape blueShape;
        MarkerAPI markerAPI;
        if (this.blueMapAPI == null) {
            this.pendingMarkers.add(() -> this.addShapeMarker(world, shape));
            return;
        }
        try {
            markerAPI = this.blueMapAPI.getMarkerAPI();
        }
        catch (IOException e) {
            return;
        }
        MarkerSet markerSet = markerAPI.createMarkerSet(MARKERSET_ID);
        markerSet.setLabel(this.label);
        if (shape instanceof AbstractPolygon) {
            double[] pointsZ;
            AbstractPolygon polygon = (AbstractPolygon)shape;
            double[] pointsX = polygon.pointsX();
            if (pointsX.length != (pointsZ = polygon.pointsZ()).length) {
                return;
            }
            Vector2d[] points = new Vector2d[pointsX.length];
            for (int i = 0; i < pointsX.length; ++i) {
                points[i] = new Vector2d(pointsX[i], pointsZ[i]);
            }
            blueShape = new de.bluecolored.bluemap.api.marker.Shape(points);
        } else if (shape instanceof AbstractEllipse) {
            AbstractEllipse ellipse = (AbstractEllipse)shape;
            double[] center = ellipse.getCenter();
            double[] radii = ellipse.getRadii();
            Vector2d centerPos = new Vector2d(center[0], center[1]);
            blueShape = de.bluecolored.bluemap.api.marker.Shape.createEllipse((Vector2d)centerPos, (double)radii[0], (double)radii[1], (int)100);
        } else {
            return;
        }
        this.blueMapAPI.getWorld(world.getUUID()).ifPresent(blueWorld -> blueWorld.getMaps().forEach(map -> {
            ShapeMarker marker = markerSet.createShapeMarker(world.getName(), map, blueShape, (float)world.getSeaLevel());
            marker.setColors(new Color(this.color), new Color(0, true));
            marker.setLabel(this.label);
            try {
                ShapeMarker.class.getMethod("setLineWidth", Integer.TYPE).invoke((Object)marker, this.weight);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        try {
            markerAPI.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void removeShapeMarker(World world) {
        if (this.blueMapAPI == null) {
            return;
        }
        try {
            MarkerAPI markerAPI = this.blueMapAPI.getMarkerAPI();
            MarkerSet markerSet = markerAPI.createMarkerSet(MARKERSET_ID);
            this.blueMapAPI.getWorld(world.getUUID()).ifPresent(blueWorld -> blueWorld.getMaps().forEach(map -> markerSet.removeMarker(world.getName())));
            markerAPI.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void removeAllShapeMarkers() {
        if (this.blueMapAPI == null) {
            return;
        }
        try {
            MarkerAPI markerAPI = this.blueMapAPI.getMarkerAPI();
            if (markerAPI.removeMarkerSet(MARKERSET_ID)) {
                markerAPI.save();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

