/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.Map;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.integration.BorderIntegration;
import org.popcraft.chunky.integration.Integration;
import org.popcraft.chunky.platform.Border;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Coordinate;
import org.popcraft.chunky.util.Formatting;

public class WorldBorderCommand
extends ChunkyCommand {
    public WorldBorderCommand(Chunky chunky) {
        super(chunky);
    }

    @Override
    public void execute(Sender sender, String[] args) {
        Selection previous = this.chunky.getSelection().build();
        if (!this.setBorderViaIntegration(previous.world())) {
            this.chunky.getSelection().worldborder();
        }
        Selection current = this.chunky.getSelection().build();
        sender.sendMessagePrefixed("format_center", Formatting.number(current.centerX()), Formatting.number(current.centerZ()));
        if (current.radiusX() == current.radiusZ()) {
            sender.sendMessagePrefixed("format_radius", Formatting.number(current.radiusX()));
        } else {
            sender.sendMessagePrefixed("format_radii", Formatting.number(current.radiusX()), Formatting.number(current.radiusZ()));
        }
        if (!previous.shape().equals(current.shape())) {
            sender.sendMessagePrefixed("format_shape", current.shape());
        }
    }

    boolean setBorderViaIntegration(World world) {
        String worldName;
        BorderIntegration worldborder;
        Map<String, Integration> integrations = this.chunky.getServer().getIntegrations();
        if (integrations.containsKey("border") && (worldborder = (BorderIntegration)integrations.get("border")).hasBorder(worldName = world.getName())) {
            Border border = worldborder.getBorder(worldName);
            Coordinate center = border.getCenter();
            this.chunky.getSelection().center(center.getX(), center.getZ()).radiusX(border.getRadiusX()).radiusZ(border.getRadiusZ()).shape(border.getShape());
            return true;
        }
        return false;
    }
}

