/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.platform.Sender;

public class PatternCommand
extends ChunkyCommand {
    private static final List<String> PATTERNS = Arrays.asList("concentric", "loop", "spiral");

    public PatternCommand(Chunky chunky) {
        super(chunky);
    }

    @Override
    public void execute(Sender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("help_pattern", new Object[0]);
            return;
        }
        String pattern = args[1].toLowerCase();
        if (!PATTERNS.contains(pattern)) {
            sender.sendMessage("help_pattern", new Object[0]);
            return;
        }
        this.chunky.getSelection().pattern(pattern);
        sender.sendMessagePrefixed("format_pattern", pattern);
    }

    @Override
    public List<String> tabSuggestions(Sender sender, String[] args) {
        if (args.length == 2) {
            return PATTERNS;
        }
        return Collections.emptyList();
    }
}

