/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Input;

public class ContinueCommand
extends ChunkyCommand {
    public ContinueCommand(Chunky chunky) {
        super(chunky);
    }

    @Override
    public void execute(Sender sender, String[] args) {
        List<GenerationTask> loadTasks;
        if (args.length > 1) {
            Optional<World> world = Input.tryWorld(this.chunky, String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)));
            if (!world.isPresent()) {
                sender.sendMessage("help_continue", new Object[0]);
                return;
            }
            loadTasks = this.chunky.getConfig().loadTask(world.get()).map(Collections::singletonList).orElse(Collections.emptyList());
        } else {
            loadTasks = this.chunky.getConfig().loadTasks();
        }
        if (loadTasks.isEmpty()) {
            sender.sendMessagePrefixed("format_continue_no_tasks", new Object[0]);
            return;
        }
        Map<World, GenerationTask> generationTasks = this.chunky.getGenerationTasks();
        loadTasks.forEach(generationTask -> {
            World world = generationTask.getSelection().world();
            if (!generationTasks.containsKey(world)) {
                generationTasks.put(world, (GenerationTask)generationTask);
                this.chunky.getScheduler().runTask((Runnable)generationTask);
                sender.sendMessagePrefixed("format_continue", world.getName());
            } else {
                sender.sendMessagePrefixed("format_started_already", world.getName());
            }
        });
    }

    @Override
    public List<String> tabSuggestions(Sender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunky.getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        return Collections.emptyList();
    }
}

