/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.iterator.ChunkIterator;
import org.popcraft.chunky.iterator.ChunkIteratorFactory;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.ShapeFactory;
import org.popcraft.chunky.util.ChunkCoordinate;
import org.popcraft.chunky.util.Pair;
import org.popcraft.chunky.util.RegionCache;

public class GenerationTask
implements Runnable {
    private static final int MAX_WORKING = 50;
    private final Chunky chunky;
    private final Selection selection;
    private final Shape shape;
    private final AtomicLong startTime = new AtomicLong();
    private final AtomicLong printTime = new AtomicLong();
    private final AtomicLong finishedChunks = new AtomicLong();
    private final AtomicLong totalChunks = new AtomicLong();
    private final Deque<Pair<Long, AtomicLong>> updateSamples = new ConcurrentLinkedDeque<Pair<Long, AtomicLong>>();
    private final Progress progress;
    private final RegionCache.WorldState worldState;
    private ChunkIterator chunkIterator;
    private boolean stopped;
    private boolean cancelled;
    private long prevTime;

    public GenerationTask(Chunky chunky, Selection selection, long count, long time) {
        this(chunky, selection);
        this.chunkIterator = ChunkIteratorFactory.getChunkIterator(selection, count);
        this.finishedChunks.set(count);
        this.prevTime = time;
    }

    public GenerationTask(Chunky chunky, Selection selection) {
        this.chunky = chunky;
        this.selection = selection;
        this.chunkIterator = ChunkIteratorFactory.getChunkIterator(selection);
        this.shape = ShapeFactory.getShape(selection);
        this.totalChunks.set(this.chunkIterator.total());
        this.progress = new Progress(selection.world().getName());
        this.worldState = chunky.getRegionCache().getWorld(selection.world().getName());
    }

    private void update(int chunkX, int chunkZ, boolean loaded) {
        long time;
        Pair<Long, AtomicLong> oldest;
        if (this.stopped) {
            return;
        }
        this.progress.chunkCount = this.finishedChunks.addAndGet(1L);
        this.progress.percentComplete = 100.0f * (float)this.progress.chunkCount / (float)this.totalChunks.get();
        long currentTime = System.currentTimeMillis();
        Pair<Long, AtomicLong> bin = this.updateSamples.peekLast();
        if (loaded) {
            this.worldState.setGenerated(chunkX, chunkZ);
            if (bin != null && (double)(currentTime - bin.left()) < 2000.0) {
                bin.right().addAndGet(1L);
            } else if (this.updateSamples.add(Pair.of(currentTime, new AtomicLong(1L)))) {
                while (!this.updateSamples.isEmpty() && (double)(currentTime - this.updateSamples.peek().left()) > 10000.0) {
                    this.updateSamples.poll();
                }
            }
        }
        long oldestTime = (oldest = this.updateSamples.peek()) == null ? currentTime : oldest.left();
        long chunksLeft = this.totalChunks.get() - this.finishedChunks.get();
        double timeDiff = (double)(currentTime - oldestTime) / 1000.0;
        if (chunksLeft > 0L && timeDiff < 0.1) {
            return;
        }
        long sampleCount = 0L;
        for (Pair<Long, AtomicLong> b : this.updateSamples) {
            sampleCount += b.right().get();
        }
        this.progress.rate = timeDiff > 0.0 ? (double)sampleCount / timeDiff : 0.0;
        if (chunksLeft == 0L) {
            time = (this.prevTime + (currentTime - this.startTime.get())) / 1000L;
            this.progress.complete = true;
        } else {
            time = (long)((double)chunksLeft / this.progress.rate);
        }
        this.progress.hours = time / 3600L;
        this.progress.minutes = (time - this.progress.hours * 3600L) / 60L;
        this.progress.seconds = time - this.progress.hours * 3600L - this.progress.minutes * 60L;
        this.progress.chunkX = chunkX;
        this.progress.chunkZ = chunkZ;
        if (chunksLeft > 0L && (this.chunky.getOptions().isSilent() || (double)(currentTime - this.printTime.get()) / 1000.0 < (double)this.chunky.getOptions().getQuietInterval())) {
            return;
        }
        this.printTime.set(currentTime);
        this.progress.sendUpdate(this.chunky.getServer().getConsoleSender());
    }

    @Override
    public void run() {
        String poolThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(String.format("Chunky-%s Thread", this.selection.world().getName()));
        Semaphore working = new Semaphore(50);
        this.startTime.set(System.currentTimeMillis());
        while (!this.stopped && this.chunkIterator.hasNext()) {
            ChunkCoordinate chunk = (ChunkCoordinate)this.chunkIterator.next();
            int chunkCenterX = (chunk.x << 4) + 8;
            int chunkCenterZ = (chunk.z << 4) + 8;
            if (!this.shape.isBounding(chunkCenterX, chunkCenterZ) || this.worldState.isGenerated(chunk.x, chunk.z)) {
                this.update(chunk.x, chunk.z, false);
                continue;
            }
            if (this.selection.world().isChunkGenerated(chunk.x, chunk.z)) {
                this.update(chunk.x, chunk.z, true);
                continue;
            }
            try {
                working.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.stop(this.cancelled);
                break;
            }
            this.selection.world().getChunkAtAsync(chunk.x, chunk.z).thenRun(() -> {
                working.release();
                this.update(chunk.x, chunk.z, true);
            });
        }
        if (this.stopped) {
            this.chunky.getServer().getConsoleSender().sendMessagePrefixed("task_stopped", this.selection.world().getName());
        } else {
            this.cancelled = true;
        }
        this.chunky.getConfig().saveTask(this);
        this.chunky.getGenerationTasks().remove(this.selection.world());
        Thread.currentThread().setName(poolThreadName);
    }

    public void stop(boolean cancelled) {
        this.stopped = true;
        this.cancelled = cancelled;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public long getCount() {
        return this.finishedChunks.get();
    }

    public ChunkIterator getChunkIterator() {
        return this.chunkIterator;
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public long getTotalTime() {
        return this.prevTime + (this.startTime.get() > 0L ? System.currentTimeMillis() - this.startTime.get() : 0L);
    }

    public Progress getProgress() {
        return this.progress;
    }

    public static class Progress {
        private final String world;
        private long chunkCount;
        private boolean complete;
        private float percentComplete;
        private long hours;
        private long minutes;
        private long seconds;
        private double rate;
        private int chunkX;
        private int chunkZ;

        private Progress(String world) {
            this.world = world;
        }

        public String getWorld() {
            return this.world;
        }

        public long getChunkCount() {
            return this.chunkCount;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public float getPercentComplete() {
            return this.percentComplete;
        }

        public long getHours() {
            return this.hours;
        }

        public long getMinutes() {
            return this.minutes;
        }

        public long getSeconds() {
            return this.seconds;
        }

        public double getRate() {
            return this.rate;
        }

        public int getChunkX() {
            return this.chunkX;
        }

        public int getChunkZ() {
            return this.chunkZ;
        }

        public void sendUpdate(Sender sender) {
            if (this.complete) {
                sender.sendMessagePrefixed("task_done", this.world, this.chunkCount, String.format("%.2f", Float.valueOf(this.percentComplete)), String.format("%01d", this.hours), String.format("%02d", this.minutes), String.format("%02d", this.seconds));
            } else {
                sender.sendMessagePrefixed("task_update", this.world, this.chunkCount, String.format("%.2f", Float.valueOf(this.percentComplete)), String.format("%01d", this.hours), String.format("%02d", this.minutes), String.format("%02d", this.seconds), String.format("%.1f", this.rate), this.chunkX, this.chunkZ);
            }
        }
    }
}

