/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.io.File;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.suggestion.SuggestionProviders;
import org.popcraft.chunky.listeners.BossBarProgress;
import org.popcraft.chunky.platform.ForgeSender;
import org.popcraft.chunky.platform.ForgeServer;
import org.popcraft.chunky.platform.impl.GsonConfig;

@Mod(value="chunky")
public class ChunkyForge {
    public static final String MODID = "chunky";
    private Chunky chunky;

    public ChunkyForge() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        File configFile = new File(event.getServer().func_71238_n(), "config/chunky.json");
        this.chunky = new Chunky(new ForgeServer(this, server), new GsonConfig(() -> this.chunky, configFile));
        if (this.chunky.getConfig().getContinueOnRestart()) {
            this.chunky.getCommands().get("continue").execute(this.chunky.getServer().getConsoleSender(), new String[0]);
        }
        Command command = context -> {
            String input;
            ForgeSender sender = new ForgeSender((CommandSource)context.getSource());
            Map<String, ChunkyCommand> commands = this.chunky.getCommands();
            int argsIndex = (input = context.getInput()).indexOf(32);
            String[] args = input.substring(argsIndex < 0 ? 0 : argsIndex + 1).split(" ");
            String subCommand = args.length > 0 && commands.containsKey(args[0]) ? args[0] : "help";
            commands.get(subCommand).execute(sender, args);
            return 1;
        };
        server.func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MODID).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"cancel").then(Commands.func_197056_a((String)"world", (ArgumentType)DimensionArgument.func_212595_a()).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"center").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"x", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"z", (ArgumentType)StringArgumentType.word()).executes(command))).executes(command))).executes(command))).then(Commands.func_197057_a((String)"confirm").executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"continue").then(Commands.func_197056_a((String)"world", (ArgumentType)DimensionArgument.func_212595_a()).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"corners").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"x1", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"z1", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"x2", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"z2", (ArgumentType)StringArgumentType.word()).executes(command))).executes(command))).executes(command))).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"help").then(Commands.func_197056_a((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"pattern").then(Commands.func_197056_a((String)"pattern", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.PATTERNS).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"pause").then(Commands.func_197056_a((String)"world", (ArgumentType)DimensionArgument.func_212595_a()).executes(command))).executes(command))).then(Commands.func_197057_a((String)"progress").executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"quiet").then(Commands.func_197056_a((String)"interval", (ArgumentType)IntegerArgumentType.integer()).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"radius").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"radius", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"radius", (ArgumentType)StringArgumentType.word()).executes(command))).executes(command))).executes(command))).then(Commands.func_197057_a((String)"reload").executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"shape").then(Commands.func_197056_a((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES).executes(command))).executes(command))).then(Commands.func_197057_a((String)"silent").executes(command))).then(Commands.func_197057_a((String)"spawn").executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"start").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"world", (ArgumentType)DimensionArgument.func_212595_a()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"shape", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"centerX", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"centerZ", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"radiusX", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"radiusZ", (ArgumentType)StringArgumentType.word()).executes(command))).executes(command))).executes(command))).executes(command))).suggests(SuggestionProviders.SHAPES).executes(command))).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"trim").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"world", (ArgumentType)DimensionArgument.func_212595_a()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"shape", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"centerX", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"centerZ", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"radiusX", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"radiusZ", (ArgumentType)StringArgumentType.word()).executes(command))).executes(command))).executes(command))).executes(command))).suggests(SuggestionProviders.SHAPES).executes(command))).executes(command))).executes(command))).then(Commands.func_197057_a((String)"worldborder").executes(command))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"world").then(Commands.func_197056_a((String)"world", (ArgumentType)DimensionArgument.func_212595_a()).executes(command))).executes(command))).executes(command)).requires(serverCommandSource -> serverCommandSource.func_197034_c(2)));
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        this.chunky.disable();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.END && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            BossBarProgress.tick(this.chunky, server);
        }
    }

    public Chunky getChunky() {
        return this.chunky;
    }
}

