/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.util;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public abstract class VoxelShapeUtils {
    public static Map<Direction, VoxelShape> generateFacingShape(VoxelShape source) {
        HashMap<Direction, VoxelShape> result = new HashMap<Direction, VoxelShape>();
        result.put(Direction.SOUTH, source);
        result.put(Direction.WEST, VoxelShapeUtils.horizontalRotateShape90(source));
        result.put(Direction.NORTH, VoxelShapeUtils.horizontalRotateShape90((VoxelShape)result.get(Direction.WEST)));
        result.put(Direction.EAST, VoxelShapeUtils.horizontalRotateShape90((VoxelShape)result.get(Direction.NORTH)));
        return result;
    }

    public static VoxelShape loadFromStrings(List<String> input) {
        try {
            ArrayList<VoxelShape> inputShapes = new ArrayList<VoxelShape>();
            for (String shapeString : input) {
                List coords = Arrays.asList(shapeString.split(",")).stream().map(s -> Double.parseDouble(s)).collect(Collectors.toList());
                inputShapes.add(Block.func_208617_a((double)((Double)coords.get(0)), (double)((Double)coords.get(1)), (double)((Double)coords.get(2)), (double)((Double)coords.get(3)), (double)((Double)coords.get(4)), (double)((Double)coords.get(5))));
            }
            VoxelShape resultShape = (VoxelShape)inputShapes.get(0);
            if (inputShapes.size() > 1) {
                for (int i = 1; i < inputShapes.size(); ++i) {
                    resultShape = VoxelShapes.func_197872_a((VoxelShape)resultShape, (VoxelShape)((VoxelShape)inputShapes.get(i)));
                }
            }
            return resultShape;
        }
        catch (Exception e) {
            MIMIMod.LOGGER.error("Failed to load collision shape for instrument. Falling back to full cube. Error: ", (Throwable)e);
            return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
    }

    private static VoxelShape horizontalRotateShape90(VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197873_a((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
        });
        return buffer[1];
    }
}

