/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.container.ContainerInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSwitchboard;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.tile.ATileInventory;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemStackHandler;

public class TileInstrument
extends ATileInventory {
    public static final String COLOR_TAG = "color";
    protected Integer color;

    public TileInstrument() {
        super(ModTiles.INSTRUMENT, 1);
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerInstrument(id, playerInventory, this.getInstrumentId(), this.func_174877_v());
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_199767_j().func_77658_a());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.color != null) {
            compound.func_74768_a(COLOR_TAG, this.color.intValue());
        }
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b(COLOR_TAG)) {
            this.color = compound.func_74762_e(COLOR_TAG);
        }
    }

    public Byte getInstrumentId() {
        return ((BlockInstrument)this.func_195044_w().func_177230_c()).getInstrumentId();
    }

    public void setColor(Integer color) {
        if (((BlockInstrument)this.func_195044_w().func_177230_c()).isDyeable().booleanValue()) {
            this.color = color;
        }
    }

    public Boolean hasColor() {
        return this.color != null && ((BlockInstrument)this.func_195044_w().func_177230_c()).isDyeable() != false;
    }

    public Integer getColor() {
        if (!((BlockInstrument)this.func_195044_w().func_177230_c()).isDyeable().booleanValue()) {
            return -1;
        }
        return this.hasColor() != false ? this.color : ((BlockInstrument)this.func_195044_w().func_177230_c()).getDefaultColor();
    }

    public String getInstrumentName() {
        return this.func_195044_w().func_177230_c().func_199767_j().func_200296_o().getString();
    }

    public ItemStack getSwitchboardStack() {
        if (this.inventory.isPresent() && ((Object)((Object)ModItems.SWITCHBOARD)).equals(((ItemStackHandler)this.inventory.orElse(null)).getStackInSlot(0).func_77973_b())) {
            return ((ItemStackHandler)this.inventory.orElse(null)).getStackInSlot(0);
        }
        return ItemStack.field_190927_a;
    }

    public Boolean shouldHandleMessage(UUID sender, Byte channel, Boolean publicTransmit) {
        ItemStack switchStack = this.getSwitchboardStack();
        if (!switchStack.func_190926_b()) {
            return ItemMidiSwitchboard.isChannelEnabled(switchStack, channel) != false && (publicTransmit != false && ItemMidiSwitchboard.PUBLIC_SOURCE_ID.equals(ItemMidiSwitchboard.getMidiSource(switchStack)) || sender != null && sender.equals(ItemMidiSwitchboard.getMidiSource(switchStack)));
        }
        return false;
    }

    public Boolean hasSwitchboard() {
        return !this.getSwitchboardStack().func_190926_b();
    }
}

