/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.container.ContainerConductor;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSwitchboard;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.network.TransmitterNotePacket;
import io.github.tofodroid.mods.mimi.common.network.TransmitterNotePacketHandler;
import io.github.tofodroid.mods.mimi.common.tile.ATileInventory;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemStackHandler;

public class TileConductor
extends ATileInventory {
    public Byte lastNote = null;
    public Boolean lastBroadcastPublic = null;
    public ArrayList<Byte> lastChannels = new ArrayList();

    public TileConductor() {
        super(ModTiles.CONDUCTOR, 1);
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerConductor(id, playerInventory, this.func_174877_v());
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_199767_j().func_77658_a());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.transmitNoteOff(this.func_145831_w());
    }

    public ItemStack getSwitchboardStack() {
        if (this.inventory.isPresent() && ((Object)((Object)ModItems.SWITCHBOARD)).equals(((ItemStackHandler)this.inventory.orElse(null)).getStackInSlot(0).func_77973_b())) {
            return ((ItemStackHandler)this.inventory.orElse(null)).getStackInSlot(0);
        }
        return ItemStack.field_190927_a;
    }

    public Boolean hasSwitchboard() {
        return !this.getSwitchboardStack().func_190926_b();
    }

    public void transmitNoteOn(World worldIn) {
        ItemStack switchStack;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b instanceof ServerWorld && this.lastNote == null && !(switchStack = this.getSwitchboardStack()).func_190926_b()) {
            this.lastNote = ItemMidiSwitchboard.getBroadcastNote(switchStack);
            this.lastBroadcastPublic = ItemMidiSwitchboard.getPublicBroadcast(switchStack);
            for (Byte channel : ItemMidiSwitchboard.getEnabledChannelsSet(switchStack)) {
                this.lastChannels.add(channel);
                TransmitterNotePacket packet = new TransmitterNotePacket(channel, this.lastNote, (byte)127, this.lastBroadcastPublic != false ? TransmitterNotePacket.TransmitMode.PUBLIC : TransmitterNotePacket.TransmitMode.LINKED);
                TransmitterNotePacketHandler.handlePacketServer(packet, this.func_174877_v(), (ServerWorld)worldIn, this.getUniqueId(), null);
            }
        }
    }

    public void transmitNoteOff(World worldIn) {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b instanceof ServerWorld) {
            if (!this.lastChannels.isEmpty() && this.lastNote != null) {
                for (Byte channel : this.lastChannels) {
                    TransmitterNotePacket packet = new TransmitterNotePacket(channel, this.lastNote, new Integer(-1).byteValue(), this.lastBroadcastPublic != false ? TransmitterNotePacket.TransmitMode.PUBLIC : TransmitterNotePacket.TransmitMode.LINKED);
                    TransmitterNotePacketHandler.handlePacketServer(packet, this.func_174877_v(), (ServerWorld)worldIn, this.getUniqueId(), null);
                }
            }
            this.lastChannels = new ArrayList();
            this.lastNote = null;
            this.lastBroadcastPublic = null;
        }
    }

    public UUID getUniqueId() {
        String posString = "con" + this.func_174877_v().func_177958_n() + this.func_174877_v().func_177956_o() + this.func_174877_v().func_177952_p();
        return UUID.nameUUIDFromBytes(posString.getBytes());
    }
}

